package com.aote.pay.boc.weinan;

import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.xianbank.tongchuan.FormatUtils;
import com.aote.pay.xianbank.tongchuan.HttpNetProvider;
import com.aote.sql.SqlServer;
import com.aote.util.MD5;
import com.aote.util.PayUtil;
import com.aote.util.UnionXmlUtils;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;

@Slf4j
@Component
public class JsApiWeiNan implements PaySuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    
    @Override
    public String prePay(JSONObject json) {String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            String posNo = wxConfig.getString("posNo");
            String signKey =  wxConfig.getString("signKey");
            String merOrderNo = PayUtil.getOrderNoByNumber();
            String tranType = "F";
            String txnAmt = String.valueOf(PayUtil.yuan2FenInt(money));
            String payType = "WEIX";
            String mid  = wxConfig.getString("mchId");
            String wechatNotify = wxConfig.getString("wechatNotify");
            String tradeNo = "";
            JSONObject body = new JSONObject();
            body.put("posNo",posNo);
            body.put("merOrderNo",merOrderNo);
            body.put("tranType",tranType);
            body.put("txnAmt",txnAmt);
            body.put("payType",payType);
            body.put("mid",mid);
            body.put("tradeNo",tradeNo);
            body.put("retUrl",wechatNotify);
            String sign;
            sign = body.toString() + "&" + signKey;
            sign = MD5.MD5Encode(sign);
            String PayUrl = wxConfig.getString("PayUrl");
            log.debug("渭南城投下单地址: {},下单bogy参数: {}", PayUrl, body);
            log.debug("下单head参数: {}", sign);
            CloseableHttpClient client ;
            CloseableHttpResponse response ;
            String res ;
            try {
                HttpPost httpPost = new HttpPost(PayUrl);
                StringEntity entityParams = new StringEntity(body.toString(), "utf-8");
                httpPost.setEntity(entityParams);
                httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
                httpPost.addHeader("sign", sign);
                client = HttpClients.createDefault();
                response = client.execute(httpPost);
                res =  EntityUtils.toString(response.getEntity());
                log.debug("请求结果：" + res);
                JSONObject responseJson = new JSONObject(res);
                if ("00".equals(responseJson.getString("respCode"))) {
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", merOrderNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", orderType);
                    saveOrder.put("flag", "JsApiWeiNan");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_sys_trace",responseJson.getString("sysTrace"));
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);

                    result.put("code", 200);
                    result.put("msg", "SUCCESS");
                    result.put("f_out_trade_no", merOrderNo);
                    result.put("f_sys_trace",responseJson.getString("sysTrace"));
                    result.put("appId", responseJson.getString("scanCode"));

                }else {
                    result.put("code", responseJson.get("sub_code"));
                    result.put("error", "下单失败，失败原因:" + responseJson.get("sub_msg").toString());
                }
            } catch (Exception e) {
                log.debug("请求响应错误");
                result.put("result_msg", "请求响应错误");
                result.put("err_msg", e.getMessage());
                throw new RuntimeException("下单请求渭南城投未正常响应");
            }
        }catch (Exception e) {
            log.debug("渭南城投下单异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String posNo = wxConfig.getString("posNo");
            String signKey =  wxConfig.getString("signKey");
            String merOrderNo = jsonObject.getString("f_out_trade_no");
            // 如果 isClose =  是  则为关闭订单，
            String isClose = jsonObject.optString("isClose","否");
            String tranType= "G";
            if ("是".equals(isClose)) {
                 tranType = "S";
            }
            String orgSysTrace = jsonObject.getString("f_sys_trace");
            JSONObject body = new JSONObject();
            body.put("posNo",posNo);
            body.put("tranType",tranType);
            body.put("mid",merOrderNo);
            body.put("orgSysTrace",orgSysTrace);
            String sign;
            sign = body.toString() + "&" + signKey;
            sign = MD5.MD5Encode(sign);
            String PayUrl = wxConfig.getString("PayUrl");

            log.debug("渭南城投查询地址: {},下单bogy参数: {}", PayUrl, body);
            log.debug("下单head参数: {}", sign);
            CloseableHttpClient client ;
            CloseableHttpResponse response ;
            String res ;

            HttpPost httpPost = new HttpPost(PayUrl);
            StringEntity entityParams = new StringEntity(body.toString(), "utf-8");
            httpPost.setEntity(entityParams);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.addHeader("sign", sign);
            client = HttpClients.createDefault();
            response = client.execute(httpPost);
            res =  EntityUtils.toString(response.getEntity());
            log.debug("请求结果：" + res);
            JSONObject responseJson = new JSONObject(res);
            if ("00".equals(responseJson.getString("respCode"))) {
                result.put("result_code", "SUCCESS");
                result.put("trade_state", "SUCCESS");
                if (!"是".equals(isClose)) {
                    if ("ZFBA".equals(responseJson.getString("oldPayType"))) {
                        result.put("transaction_id", responseJson.getString("oldTradeNo"));
                    }
                    if ("WEIX".equals(responseJson.getString("oldPayType"))) {
                        result.put("transaction_id", responseJson.getString("oldTradeId"));
                    }
                    if ("UPAY".equals(responseJson.getString("oldPayType"))) {
                        result.put("transaction_id", responseJson.getString("oldPayVounum"));
                    }

                    // 订单号
            //                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(jsonObject.getString("f_create_time"));
            //                    String s = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
                    // 交易日期
                    result.put("time_end", responseJson.getString("bankDate")+responseJson.getString("bankTime"));
                    result.put("total_fee", jsonObject.getInt("f_total_fee"));
                } else {
                    sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已无效' where f_out_trade_no = '" + merOrderNo + "'");
                }

            }else {
                result.put("result_code", "FAIL");
                result.put("result_msg",  responseJson.getString("respMsg"));
            }
            } catch (Exception e) {
                log.debug("渭南城投订单异常", e);
                result.put("result_code", "FAIL");
                result.put("trade_state", "FAIL");
                result.put("result_msg", e.getMessage());
            }
            log.debug("查询订单返回: {}", result.toString());
            return result.toString();
    }
}
