package com.aote.filter;


import com.af.plugins.AESUtil;
import com.aote.config.SystemConfig;
import com.aote.redis.RedisUtil;
import com.aote.util.GetUserIp;
import com.aote.weixin.Config;
import io.jsonwebtoken.Claims;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * @author tzh
 */
@Component
public class AuthorizeFilter implements Filter {
    static Logger log = Logger.getLogger(AuthorizeFilter.class);

    private final static RedisUtil redisUtil = RedisUtil.getInstance();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req =(HttpServletRequest) servletRequest;
        HttpServletResponse resp = (HttpServletResponse) servletResponse;
        ServerHttpRequest request = new ServletServerHttpRequest(req);
        ServerHttpResponse response = new ServletServerHttpResponse(resp);
        // todo 这里应该放一个白名单 让有的请求路径不进行过滤

        String ip = GetUserIp.getIpAdrress(req);
        String url = ip + request.getURI().getPath();
        if (Config.isPassUri(url)) {
            filterChain.doFilter(servletRequest, servletResponse);
            log.debug("进入指定url放行了");
        } else {
            // 从请求头中获取Token
            String Token = req.getHeader("Authorization");
            log.debug("获取的Authorization:" + Token);
            if (Token != null && !"".equals(Token)) {
                try {
                    Token = Token.substring(7);
                    if ("DEBUG".equals(Token)){
                        filterChain.doFilter(servletRequest, servletResponse);
                        log.debug("DEBUG模式放行了");
                        return;
                    }
                    Token = AESUtil.decrypt(Token, SystemConfig.DataSecurity.getAesKey());
                    Claims claims = JwtAuthUtil.parseToken(Token);
                    //获取Token中用户id
                    if (claims == null) {
                        response.setStatusCode(HttpStatus.UNAUTHORIZED);
                        log.debug("用户认证失败URL:" + url);
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().write("用户认证失败！");
                        return;
                    }
                    String openid = claims.getSubject();
                    log.debug("openid=" + openid);
                    if (openid == null || "".equals(openid)) {
                        response.setStatusCode(HttpStatus.UNAUTHORIZED);
                        log.debug("用户认证失败URL:" + url);
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().write("用户认证失败！");
                        return;
                    }
                    String saveToken = String.valueOf(redisUtil.get("openId_" + openid));
                    if (!saveToken.equals(Token)){
                        response.setStatusCode(HttpStatus.UNAUTHORIZED);
                        log.debug("用户认证失败URL:" + url);
                        resp.setCharacterEncoding("UTF-8");
                        resp.getWriter().write("用户认证失败,Token不正确！");
                        return;
                    }
                    log.debug("-----请求地址："+req.getRequestURI()+"-----");
                    log.debug("进入chain.doFilter");
                    filterChain.doFilter(servletRequest, servletResponse);
                    log.debug("出入chain.doFilter");
                } catch (ServletException e) {
                    log.error("过滤器日志ServletException：",e);
                    response.setStatusCode(HttpStatus.UNAUTHORIZED);
                    log.debug("用户认证失败URL:" + url);
                    resp.setCharacterEncoding("UTF-8");
                    throw e;
                } catch (Throwable e) {
                    log.error("过滤器日志Throwable：",e);
                    response.setStatusCode(HttpStatus.UNAUTHORIZED);
                    log.debug("用户认证失败URL:" + url);
                    resp.setCharacterEncoding("UTF-8");
                    throw new ServletException("获取用户信息错误，Token=" + Token, e);
                }
            } else {
                response.setStatusCode(HttpStatus.UNAUTHORIZED);
                log.debug("用户认证失败URL:" + url);
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().write("用户认证失败！");
            }
        }

    }

    @Override
    public void destroy() {

    }
}

