package com.jonnyliu.proj.wechat.handle;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.aote.logic.LogicServer;
import com.jonnyliu.proj.wechat.annotation.MessageProcessor;
import com.jonnyliu.proj.wechat.enums.EventType;
import com.jonnyliu.proj.wechat.enums.MessageType;
import com.jonnyliu.proj.wechat.handler.AbstractMessageHandler;
import com.jonnyliu.proj.wechat.message.request.BaseRequestMessage;
import com.jonnyliu.proj.wechat.message.request.UnsubscribeEventRequestMessage;
import com.jonnyliu.proj.wechat.message.response.BaseResponseMessage;
import com.jonnyliu.proj.wechat.utils.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: JoeCdy
 * @Description: 用户取消关注事件处理器
 * @Date: Created in 16:03 2020/4/17
 */
@Slf4j
//@Component
@MessageProcessor(messageType = MessageType.EVENT, eventType = EventType.EVENT_UNSUBSCRIBE)
public class UnsubscribeEventHandler extends AbstractMessageHandler {

    @Autowired
    private LogicServer logicServer;

    @Override
    public BaseResponseMessage doHandleMessage(BaseRequestMessage baseRequestMessage) {
        UnsubscribeEventRequestMessage unSubEventRequestMessage = (UnsubscribeEventRequestMessage) baseRequestMessage;
        String xml = MessageUtils.toXml(unSubEventRequestMessage);
        JSONObject jsonObject = XML.toJSONObject(xml);
        try {
            logicServer.run("addFollowInfo", jsonObject.get("xml").toString());
        } catch (Exception e) {
            log.info("处理用户取消关注时出错", e);
        }
        return null;
    }

}
