package com.jonnyliu.proj.wechat.handle;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.aote.logic.LogicServer;
import com.jonnyliu.proj.wechat.annotation.MessageProcessor;
import com.jonnyliu.proj.wechat.enums.EventType;
import com.jonnyliu.proj.wechat.enums.MessageType;
import com.jonnyliu.proj.wechat.handler.AbstractMessageHandler;
import com.jonnyliu.proj.wechat.message.request.BaseRequestMessage;
import com.jonnyliu.proj.wechat.message.request.ScanQrWithParameterEventRequestMessage;
import com.jonnyliu.proj.wechat.message.response.BaseResponseMessage;
import com.jonnyliu.proj.wechat.utils.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: JoeCdy
 * @Description: 用户关注事件处理器
 * @Date: Created in 16:52 2020/4/15
 */
@Slf4j
//@Component
@MessageProcessor(messageType = MessageType.EVENT, eventType = EventType.EVENT_SUBSCRIBE)
public class SubscribeEventMessageHandler extends AbstractMessageHandler {

    @Autowired
    private LogicServer logicServer;

    @Override
    public BaseResponseMessage doHandleMessage(BaseRequestMessage baseRequestMessage) {
        // 用户未关注时扫描二维码事件
        if (baseRequestMessage instanceof ScanQrWithParameterEventRequestMessage) {
            ScanQrWithParameterEventRequestMessage scanQrWithParameterEventRequestMessage = (ScanQrWithParameterEventRequestMessage) baseRequestMessage;
            String xml = MessageUtils.toXml(scanQrWithParameterEventRequestMessage);
            JSONObject jsonObject = XML.toJSONObject(xml);
            try {
                logicServer.run("addFollowInfo", jsonObject.get("xml").toString());
            } catch (Exception e) {
                log.info("处理用户未关注时扫描二维码关注事件异常", e);
            }
        } else {
            // 正常关注事件
        }
        //language=TEXT
        String s = "您好，感谢您关注“邢台燃气”微信公众号，我们将竭诚为您服务，客服咨询电话0319-5995110！\n" +
                "\n" +
                "1、邢台燃气公众号缴费视频教程，请查看<a href=\"https://mp.weixin.qq.com/s/4N_aG-wx1y8sjHRpxIe_kw\">网上缴费视频教程</a>\n" +
                "2、如何进行网上缴费？查询用户编号？查找写卡网点等，请点击<a href=\"https://mp.weixin.qq.com/s/8Siwt9qa8jN2r2PSzq-_Cg\">缴费操作说明</a>";
        return MessageUtils.buildTextResponseMessage(baseRequestMessage, s);
    }
}
