package com.aote.weixin;

import com.aote.rs.WeiXinService;
import com.aote.v4.compatibility.liuli.config.service.LiuLiConfigService;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * 配置处理服务
 */
@Component
public class WechatConfigService {
    private static Logger log = LoggerFactory.getLogger(WechatConfigService.class);
    private static final String WECHAT_CONFIG_NAME = "wechatConfig";
    private static final String WECHAT_CLIENT_CONFIG_NAME = "wechatClientConfig";
    private static final String WECHAT_LAUNCH_CONFIG_NAME = "wechatLaunchConfig";
    private static final String WECHAT_FILTER_CONFIG_NAME = "filterConfig";

    public static final String DEFAULT_ORG_NAME = "standard";
    private static  LiuLiConfigService liuLiConfigService;

    public static <T> T requireNonNullElse(T obj, T defaultValue) {
        return (obj != null) ? obj : defaultValue;
    }

    @Autowired
    public void setLiuLiConfigService(LiuLiConfigService liuLiConfigService) {
        WechatConfigService.liuLiConfigService = liuLiConfigService;
    }

    private JSONObject getLiuLiConfig(String configName){
        JSONObject jsonObject = liuLiConfigService.get(configName);
        log.info("最后查询配置，相关信息：" + jsonObject);
        return jsonObject;
    }

    public JSONObject getLaunchConfig() {
        JSONObject jsonObject = getLiuLiConfig(WechatConfigService.WECHAT_CONFIG_NAME);
        return jsonObject;
    }

    public JSONObject getFilterConfig() {
        JSONObject jsonObject = getLiuLiConfig(WechatConfigService.WECHAT_CONFIG_NAME);
        return jsonObject;
    }

    public JSONObject getConfig(String orgName) {
        JSONObject jsonObject = getLiuLiConfig(WechatConfigService.WECHAT_CONFIG_NAME).getJSONObject(requireNonNullElse(orgName, DEFAULT_ORG_NAME));
        if (jsonObject.has("authInfo")) {
            return jsonObject.getJSONObject("authInfo");
        } else {
            return jsonObject;
        }
    }
    public JSONObject getClientConfig(String orgName) {
        JSONObject jsonObject = getLiuLiConfig(WechatConfigService.WECHAT_CLIENT_CONFIG_NAME).getJSONObject(requireNonNullElse(orgName,DEFAULT_ORG_NAME));
        if (jsonObject.has("authInfo")) {
            return jsonObject.getJSONObject("authInfo");
        } else {
            return jsonObject;
        }
    }
    public JSONObject getParamConfig(String orgName,String configName) {
        JSONObject jsonObject = getLiuLiConfig(configName).optJSONObject("default");
        return jsonObject;
    }
}
