package com.aote.util.msgpush;

import cn.hutool.http.HttpUtil;
import com.aote.util.AccessToken;
import com.aote.util.WechatApiUtil;
import com.aote.util.WechatUrl;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 单条消息模板推送公共类
 */
@Component
public class MsgModelPush {
    static Logger log = LoggerFactory.getLogger(MsgModelPush.class);
    @Autowired
    private WechatApiUtil wechatApiUtil;

    public String sendMsg(String openid, String orgname, String url, String templateId, JSONObject sendData) {
        String rs = "failed";
        try {
            // 获取授权accessToken
            String access_token = wechatApiUtil.getAuthToken(orgname);
            JSONObject body = new JSONObject();
            body.put("touser", openid);
            body.put("template_id", templateId);
            body.put("data", sendData);
            body.put("url", url);
            // 请求模板消息发送
            for (int i = 0; i < 2; i++) {
                // 请求模板消息发送
                String templatePath = WechatUrl.MSGPUSH_API.replace("ACCESS_TOKEN", access_token);
                String result = sendPost(templatePath, body.toString());
                JSONObject resMsg = new JSONObject(result);
                if (!"ok".equals(resMsg.getString("errmsg"))) {
                    // 如果是accessToken问题,刷新重试
                    if (checkAccessTokenInvalid(resMsg.getInt("errcode"))) {
                        wechatApiUtil.clearQuota();
                        continue;
                    }
                    log.debug("消息推送失败" + openid);
                } else {
                    rs = "success";
                }
                break;
            }
        } catch (Exception e) {
            log.debug("单条模板消息推送异常:", e);
        }
        return rs;
    }

    /**
     * 检查是否是token无效或者失效
     * @param errCode 错误码
     * @return 结果
     */
    public static Boolean checkAccessTokenInvalid  (int errCode) {
        int[] code = new int[]{40001, 40014, 41001, 42001,};
        for (int i = 0; i < code.length; i++) {
            if (errCode == code[i]) {
                return true;
            }
        }
        return false;
    }

    public static String sendPost(String postUrl, String body) {
        String result = HttpUtil.post(postUrl, body);
        log.debug("请求返回:" + result);
        return result;
    }

}
