package com.aote.util;

import org.apache.log4j.Logger;
import java.io.*;
import java.util.Properties;

public class PropertiesUtil {
    static Logger log = Logger.getLogger(Util.class);

    /**
     * 读取微信默认的properties文件
     * @param key
     * @return
     */
    public static String getProperties(String key) {
        InputStream is = null;
        String value = null;
        try {
            is = PropertiesUtil.class.getClassLoader().getResourceAsStream("wechatConfig.properties");
            Properties prop = new Properties();
            prop.load(is);
            value = prop.getProperty(key);
        } catch (Exception e) {
            log.debug("获取微信properties失败,key:" + key + ",错误原因:" + e);
        } finally {
            if(is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    /**
     * 读取properties文件
     * @param fileName 文件名称
     * @param key
     * @return
     */
    public static String getProperties(String fileName,String key) {
        InputStream is = null;
        String value = null;
        try {
            is = PropertiesUtil.class.getClassLoader().getResourceAsStream(fileName);
            Properties prop = new Properties();
            prop.load(is);
            value = prop.getProperty(key);
        } catch (Exception e) {
            log.debug("获取"+fileName+"失败,key:" + key + ",错误原因:" + e);
        } finally {
            if(is != null) {
                try {
                    is.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        System.out.println(PropertiesUtil.getProperties("wechatConfig.properties","server"));
//        JSONObject dataInfo = new JSONObject();
//        JSONObject data = new JSONObject();
//        data.put("f_userid", "11140662");
//        data.put("f_operator", "韩乐");
//        data.put("f_paytype", "1");
//        data.put("f_operat_id", "123123");
//        data.put("f_feetype", "1");
//        data.put("f_otherfeename", "app收费");
//        data.put("f_model", "其他");
//        System.out.println(AttachUtil.transKey(data, false));
    }
}
