package com.aote.rs.wechatpay;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.aote.logic.LogicServer;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Iterator;

/**
 * 微信支付成功后交易处理
 */
@Component
public class WxPayment {

    static Logger log = Logger.getLogger(WxPayment.class);

    @Autowired
    private LogicServer logicServer;


    @SuppressWarnings("unchecked")
    public String pay(String value) {
        JSONObject data = PayFee.conversionSave(value);
        log.debug("解析好的数据:" + data);
        String attach = String.valueOf(data.get("f_attach"));
        // 添加attch参数
        JSONObject attachJson = new JSONObject(attach);
        Iterator it = attachJson.keys();
        while (it.hasNext()) {
            String keyName = it.next().toString();
            Object keyValue = attachJson.get(keyName);
            log.debug("attach参数key: " + keyName + ", value: " + keyValue);
            data.put(keyName, keyValue);
        }
        try {
            // 不更新openid, 下单时需要存入
            data.remove("f_openid");
            // 更新中间表
            logicServer.run("savewxreturnxml", data);
            // 查询该订单是否已有收费记录
            Object searchIsPayFee = logicServer.run("searchIsPayFee", data);
            if (searchIsPayFee.toString().isEmpty()) {
                // 取支付完成时间转换为yyyy-MM-dd HH:mm:ss(存入收费记录)
                String f_time_end = String.valueOf(data.get("f_time_end"));
                DateTime parse = DateUtil.parse(f_time_end, DatePattern.PURE_DATETIME_PATTERN);
                String time_end = DateUtil.formatDateTime(parse);
                data.put("f_operate_date", time_end);
                logicServer.run("payfee", data);
            }
            return "SUCCESS";
        } catch (Exception e) {
            log.debug("执行缴费逻辑出错:", e);
            return "FAIL";
        }
    }
}
