package com.aote.pay.icbc.chengran;


import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.UiIcbcClient;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1;
import com.icbc.api.request.CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1;
import com.icbc.api.response.CardbusinessAggregatepayB2cOnlineOrderqryResponseV1;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;


@Slf4j
@Component
public class JsApiZhouKou implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 线上POS聚合支付非埋名消费下单
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        HttpServletRequest request1 = (HttpServletRequest) json.get("request");

        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        String result = "";
        try {
            // 在API开放平台注册时生成
            String APP_ID = wxConfig.getString("app_id");

            // biz_content请求参数的集合
            // 商户编号
            String merId = wxConfig.getString("mer_id");
            // 商户订单号
            String outTradeNo = PayUtil.getOutTradeNo();
            // 收单产品协议编号
            String merPrtclNo = wxConfig.getString("merPrtclNo");
            // 订单金额，单位为分
            String orderAmt = String.valueOf(PayUtil.yuan2FenInt(money));
            // 异步通知商户URL，端口必须为443或80
            String notifyUrl = wxConfig.getString("wechatNotify");
            // 门店名称，用于显示在买单页上。
            String saleDepName = wxConfig.getString("saleDepName");
            // 微信商品描述(微信支付下，body不能为空)
            String body = wxConfig.getString("body");
            // 商户账号，商户入账账号，只能交易时指定。
            String merAcct = wxConfig.getString("mer_acct");
            // 附加数据，在查询API和支付通 知中原样返回
            int len = 127;
            String attachs = attach;
            if(attachs.length() > len) {
                attachs = attachs.substring(0, len);
            }

            CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1.CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1Biz bizContent = new CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1.CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1Biz();
            bizContent.setAttach(attachs);
            bizContent.setBody(body);
            bizContent.setIcbc_appid(APP_ID);
            bizContent.setMer_id(merId);
            bizContent.setMer_prtcl_no(merPrtclNo);
            bizContent.setMer_acct(merAcct);
            bizContent.setNotify_url(notifyUrl);
            bizContent.setOrder_amt(orderAmt);
            bizContent.setOut_trade_no(outTradeNo);
            bizContent.setSaledepname(saleDepName);

            // 私钥
            String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
            // 请求地址
            String requestUrl = wxConfig.getString("requestUrl");
            // 下单参数
            String paramMap = new JSONObject(bizContent).toString();
            log.debug("周口工行下单地址: {},下单参数: {}", requestUrl, paramMap);

            UiIcbcClient client = new UiIcbcClient(APP_ID, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, IcbcConstants.CHARSET_UTF8);
            CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1 request = new CardbusinessAggregatepayB2cOnlineUiConsumepurchaseshowpayRequestV1();
            request.setServiceUrl(requestUrl);
            request.setBizContent(bizContent);
            try {
                result = client.buildPostForm(request);
                log.debug("工行下单返回数据: {}", result);
                if (result.length() > 0) {
                    // 保存下单信息到中间表
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", outTradeNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", "燃气收费");
                    saveOrder.put("flag", "JsApiZhouKou");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", orderAmt);
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);
                }
            } catch (IcbcApiException e) {
                e.printStackTrace();
                log.debug("周口工行下单返回结果异常错误", e);
            }
        } catch (Exception e) {
            log.debug("周口工行下单异常错误", e);
        }
        return result;
    }


    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 在API开放平台注册时生成
            String app_id = wxConfig.getString("app_id");

            // biz_content参
            // 商户编号
            String merId = wxConfig.getString("mer_id");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 操作标志，0-查询；1-关单
            String deal_flag = "0";
            CardbusinessAggregatepayB2cOnlineOrderqryRequestV1.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1Biz bizContent = new CardbusinessAggregatepayB2cOnlineOrderqryRequestV1.CardbusinessAggregatepayB2cOnlineOrderqryRequestV1Biz();
            bizContent.setMer_id(merId);
            bizContent.setOut_trade_no(outTradeNo);
            bizContent.setDeal_flag(deal_flag);
            bizContent.setIcbc_appid(app_id);
            // 私钥
            String MY_PRIVATE_KEY = wxConfig.getString("privateKey");
            // 公钥
            String APIGW_PUBLIC_KEY = wxConfig.getString("pubKey");
            // 查询地址
            String queryUrl = wxConfig.getString("queryUrl");
            // 查询参数
            String paramMap = new JSONObject(bizContent).toString();
            log.debug("周口工行查询地址: {},查询参数: {}", queryUrl, paramMap);
            DefaultIcbcClient client = new DefaultIcbcClient(app_id, IcbcConstants.SIGN_TYPE_RSA2, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            CardbusinessAggregatepayB2cOnlineOrderqryRequestV1 request = new CardbusinessAggregatepayB2cOnlineOrderqryRequestV1();
            request.setBizContent(bizContent);
            request.setServiceUrl(queryUrl);
            CardbusinessAggregatepayB2cOnlineOrderqryResponseV1 response;
            try {
                // msgId消息通讯唯一编号，要求每次调用独立生成，APP级唯一
                String msgid = System.currentTimeMillis() + "";
                response = client.execute(request, msgid);
                JSONObject jsonResponse = new JSONObject(response);
                log.debug("返回信息: {}", jsonResponse.toString());
                if (response.getReturnCode() == 0) {
                    if (!"success".equals(response.getReturnMsg())) {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", response.getReturnMsg());
                        log.debug("查询失败", response.getReturnMsg());
                    }
                    //获取支付状态 0-支付,2-交易状态异常
                    String paystatus = response.getPay_status();
                    if ("0".equals(paystatus)) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        // 订单号
                        result.put("transaction_id", response.getOrder_id());
                        // 交易日期
                        result.put("time_end", response.getPay_time());
                        // 交易金额
                        result.put("total_fee", response.getTotal_amt());
                    } else {
                        result.put("result_code", "FAIL");
                        result.put("return_msg", paystatus);
                        log.debug("订单状态不等于已支付：" + paystatus);
                    }
                } else {
                    result.put("result_code", "FAIL");
                    result.put("return_msg", response.getReturnMsg());
                    log.debug("请求结果失败:" + response.getReturnMsg());
                }
            } catch (IcbcApiException e) {
                log.error("操作失败：原因" + e.getMessage());
                result.put("result_code", "FAIL");
                result.put("return_msg", "系统异常");
            }
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("工行查询订单异常：" + e);
        }
        return result.toString();
    }
}
