package com.aote.pay.huatong;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

import javax.net.ssl.*;

import com.iflytek.wst.gateway.sdk.client.ApacheHttpClient;
import com.iflytek.wst.gateway.sdk.constant.SdkConstant;
import com.iflytek.wst.gateway.sdk.enums.HttpMethod;
import com.iflytek.wst.gateway.sdk.enums.ParamPosition;
import com.iflytek.wst.gateway.sdk.enums.Scheme;
import com.iflytek.wst.gateway.sdk.model.ApiRequest;
import com.iflytek.wst.gateway.sdk.model.ApiResponse;
import com.iflytek.wst.gateway.sdk.model.HttpClientBuilderParams;

public class WstRestClient extends ApacheHttpClient {
    // 单例模式
    private static WstRestClient instance = new WstRestClient();

    public static WstRestClient getInstance() {
        return instance;
    }

    // TODO 下面的参数，需要改为从配置文件读取
    public String appKey = "7b4d594bf95e446aae00892b7fe6d1fe";
    public String appSecret = "389C41639E79D91F823D850AFB2FCFF7";
    public Scheme scheme = Scheme.HTTPS;
    public String host = "www.ahzwfw.gov.cn";
    public String contextPath = "/wst-gateway";


    private WstRestClient() {
        // HTTP Client init
        HttpClientBuilderParams httpClientBuilderParams = new HttpClientBuilderParams();
        httpClientBuilderParams.setAppKey(appKey);
        httpClientBuilderParams.setAppSecret(appSecret);
        httpClientBuilderParams.setScheme(scheme);
        httpClientBuilderParams.setHost(host);
        httpClientBuilderParams.setContextPath(contextPath);

        // HTTPS客户端需要单独设置，禁用证书校验
        if (scheme == Scheme.HTTPS) {
            //HTTPS Client init
            /**
             * HTTPS request use DO_NOT_VERIFY mode only for demo
             * Suggest verify for security
             */
            X509TrustManager xtm = new X509TrustManager() {
                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    X509Certificate[] x509Certificates = new X509Certificate[0];
                    return x509Certificates;
                }
            };

            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{xtm}, new SecureRandom());

            } catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            } catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };

            httpClientBuilderParams.setSslSocketFactory(sslContext.getSocketFactory());
            httpClientBuilderParams.setX509TrustManager(xtm);
            httpClientBuilderParams.setHostnameVerifier(DO_NOT_VERIFY);
        }

        super.init(httpClientBuilderParams);
    }



    public ApiResponse getUserInfoByToken(String token){
        ApiRequest request = new ApiRequest(HttpMethod.GET, "/user/getUserInfoByToken");
        request.addParam("token", token, ParamPosition.QUERY, true);
        request.addParam("serviceId", "1", ParamPosition.QUERY, true);
        request.addParam("roleCode", "", ParamPosition.QUERY, true);
        return sendSyncRequest(request);
    }

}
