package com.aote.pay.ccb_gongyi.qianneng;

import org.bouncycastle.util.encoders.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import java.security.Key;
import java.security.Security;


public class DesCbcSecurity {
    private static final String ALGORITHM = "DES";

    //8位默认密钥
    private static final String DEFAULT_KEY = "Key4COM!";


    private static Key getKey(String strKey) throws Exception {
        Security.addProvider(new com.sun.crypto.provider.SunJCE());
        return getKey(strKey.getBytes("UTF-8"));
    }

    /**
     * 从指定字符串生成密钥，密钥所需的字节数组长度为8位 不足8位时后面补0，超出8位只取前8位
     *
     * @param arrBTmp 构成该字符串的字节数组
     * @return 生成的密钥
     * @throws Exception
     */
    private static Key getKey(byte[] arrBTmp) throws Exception {
        // 创建一个空的8位字节数组（默认值为0）
        byte[] arrB = new byte[8];
        // 将原始字节数组转换为8位
        for (int i = 0; i < arrBTmp.length && i < arrB.length; i++) {
            arrB[i] = arrBTmp[i];
        }
        // 生成密钥
        Key key;
        key = new javax.crypto.spec.SecretKeySpec(arrB, "DES");
        return key;
    }


    /**
     * 根据密匙进行DES加密
     *
     * @param keyStr    密匙
     * @param srcString 要加密的信息
     * @return String 加密后的信息
     */
    public static String encrypt(String keyStr, String srcString) throws Exception {
        // 定义要生成的密文
        byte[] cipherByte = null;

        //生成密钥
        Key key = getKey(keyStr);

        // 得到加密/解密器
        Cipher c1 = Cipher.getInstance(ALGORITHM);
        // 用指定的密钥和模式初始化Cipher对象
        // 参数:(ENCRYPT_MODE, DECRYPT_MODE, WRAP_MODE,UNWRAP_MODE)
        c1.init(Cipher.ENCRYPT_MODE, key);
        // 对要加密的内容进行编码处理,
        cipherByte = c1.doFinal(srcString.getBytes("UTF-8"));

        // 返回密文的十六进制形式
        return byte2hex(cipherByte);
    }

    public static String defaultEncrypt(String srcString) throws Exception {
        return encrypt(DEFAULT_KEY, srcString);
    }

    /**
     * 根据密匙进行DES解密
     *
     * @param keyStr          密匙
     * @param encryptedString 要解密的密文
     * @return String 返回解密后信息
     */
    public static String decrypt(String keyStr, String encryptedString) throws Exception {

        byte[] cipherByte = null;

        //生成密钥
        Key key = getKey(keyStr);

        // 得到加密/解密器
        Cipher c1 = Cipher.getInstance(ALGORITHM);
        // 用指定的密钥和模式初始化Cipher对象
        c1.init(Cipher.DECRYPT_MODE, key);
        // 对要解密的内容进行编码处理
        cipherByte = c1.doFinal(hex2byte(encryptedString));

        // return byte2hex(cipherByte);
        return new String(cipherByte, "UTF-8");
    }

    public static String defaultDecrypt(String encryptedString) throws Exception {
        return decrypt(DEFAULT_KEY, encryptedString);
    }

    /**
     * 将二进制转化为16进制字符串
     *
     * @param b 二进制字节数组
     * @return String
     */
    public static String byte2hex(byte[] b) {

        if (null == b) {
            return null;
        }

        StringBuffer hs = new StringBuffer("");
        String stmp = "";
        for (int n = 0; n < b.length; n++) {
            stmp = (java.lang.Integer.toHexString(b[n] & 0XFF));
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
            } else {
                hs.append(stmp);
            }
        }
        return hs.toString().toUpperCase();
    }

    /**
     * 十六进制字符串转化为2进制
     *
     * @param hex
     * @return
     */
    public static byte[] hex2byte(String hex) throws Exception {
        if (null == hex || hex.length() % 2 != 0) {
            throw new Exception();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0, j = 0, l = hex.length(); i < l; i++, j++) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
        }
        return b;
    }



    /**
     * 将十六进制的数据转化为低位在前，高位在后的格式
     */
    public static String lowHigh(int var0) {
        int var1 = 1;
        int var2 = var0 >> 8;
        int var3 = var0 & 255;
        String var4 = Integer.toHexString(var2);
        String var5 = Integer.toHexString(var3);
        if (var4.length() > 2) {
            do {
                if (var1 > 1) {
                    var2 >>= 8;
                }
                var4 = Integer.toHexString(var2 >> 8);
                var5 = var5 + Integer.toHexString(var2 & 255);
                ++var1;
            } while (var4.length() > 2);
        }
        if (var4.length() < 2) {
            var4 = "0" + var4;
        }
        if (var5.length() < 2) {
            var5 = "0" + var5;
        }
        return var5 + var4;
    }

    /**
     * 16进制表示的字符串转换为字节数组
     *
     * @param hexString 16进制表示的字符串
     * @return byte[] 字节数组
     */
    public static byte[] hexStringToByteArray(String hexString) {
        hexString = hexString.replaceAll(" ", "");
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            // 两位一组，表示一个字节,把这样表示的16进制字符串，还原成一个字节
            bytes[i / 2] = (byte) ((Character.digit(hexString.charAt(i), 16) << 4) + Character
                    .digit(hexString.charAt(i + 1), 16));
        }
        return bytes;
    }


    public static String des3EncodeECB(String keyStr, String data) throws Exception {
        DESedeKeySpec spec = new DESedeKeySpec(keyStr.getBytes());
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
        Key deskey = keyfactory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
        cipher.init(Cipher.ENCRYPT_MODE, deskey);
        byte[] bOut = cipher.doFinal(data.getBytes("UTF-8"));
        return new String(Base64.encode(bOut),"UTF-8");
    }

    public static String des3DecodeECB(String keyStr, String data) throws Exception {
        data = data.replaceAll("\r\n", "");
        DESedeKeySpec spec = new DESedeKeySpec(keyStr.getBytes());
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
        Key deskey = keyfactory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
        cipher.init(Cipher.DECRYPT_MODE, deskey);
        byte[] bout = cipher.doFinal(Base64.decode(data.getBytes("UTF-8")));
        return new String(bout, "UTF-8");
    }
}
