package com.aote.pay.boc.yongzhou;

import cn.hutool.core.date.DateTime;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.bocom.api.DefaultBocomClient;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.aote.pay.boc.yongzhou.MPNG210003RequestV1.MPNG210003RequestV1Biz;
import com.aote.pay.boc.yongzhou.MPNG210003RequestV1.MPNG210003RequestV1Biz.ReqBody;
import com.aote.pay.boc.yongzhou.MPNG210003RequestV1.MPNG210003RequestV1Biz.ReqBody.RequireFields;
import com.aote.pay.boc.yongzhou.MPNG210003RequestV1.MPNG210003RequestV1Biz.ReqHead;

import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
@Component
public class JsApiYongZhouH5 implements PaySuper , RefundSuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private JsApiYongZhou jsApiYongZhou;
    
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        String orderType = json.optString("orderType", "燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        // 商品描述
        String body = orderType + "-" + userfilesid;
        try {
            String APP_ID = wxConfig.getString("APP_ID");
            String MCH_ID = wxConfig.getString("MCH_ID");
            String partner_id = wxConfig.getString("partner_id");
            String MY_PRIVATE_KEY = wxConfig.getString("MY_PRIVATE_KEY");
            String notifyUrl = wxConfig.getString("wechatNotify");
            String APIGW_PUBLIC_KEY = wxConfig.getString("APIGW_PUBLIC_KEY");
            DefaultBocomClient client = new DefaultBocomClient(APP_ID, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            client.ignoreSSLHostnameVerifier();
            String h5Url = wxConfig.getString("h5Url");
            String txnOrderId = PayUtil.getOutTradeNo();
            /**
             * 测试环境可以忽略SSL证书告警，生产环境不可忽略
             */
            MPNG210003RequestV1 request = new MPNG210003RequestV1();
            request.setServiceUrl(h5Url);

            MPNG210003RequestV1Biz bizContent = new MPNG210003RequestV1Biz();
            ReqHead reqHead = new ReqHead();
            bizContent.setReqHead(reqHead);
            reqHead.setTransTime(new DateTime().toString("yyyyMMddHHmmss"));
            reqHead.setVersion("1.0");
            ReqBody reqBody = new ReqBody();
            bizContent.setReqBody(reqBody);
            reqBody.setValidPeriod("");
            reqBody.setTranScene("B2C-H5-ALIPAY");
            // 商户号
            reqBody.setMerPtcId(MCH_ID);
            // 当前时间
            reqBody.setMerTradeTime(new SimpleDateFormat("HHmmss").format(new Date()));
            // 回调地址
            reqBody.setNotifyUrl(notifyUrl);
            // 日期
            String trDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            reqBody.setMerTradeDate(trDate);
            reqBody.setShopId("");
            reqBody.setPartnerId(partner_id);
            // 系统订单号
            reqBody.setPayMerTranNo(txnOrderId);
            //
            reqBody.setJumpUrl("");
            // 商户备注
            reqBody.setMerMemo(attach);
            reqBody.setTotalAmount(money);


            List<RequireFields> requireFields = new ArrayList<RequireFields>();
            RequireFields require_fields = new RequireFields();
            requireFields.add(require_fields);
            reqBody.setRequireFields(requireFields);
            require_fields.setRequireField("");
            reqBody.setLocation("ONLINE");
            reqBody.setCurrency("CNY");
            reqBody.setTranContent(body);
            reqBody.setNoDsctAmount("");
            request.setBizContent(bizContent);
            log.debug("永州交行H5下单地址: {},下单bogy参数: {}", h5Url, bizContent.toString());
            try {
                MPNG210003ResponseV1 response = client.execute(request, UUID.randomUUID().toString().replace("-", ""));
                log.debug("下单请求结果: {}", response.toString());
                if (response.isSuccess()) {
                    if ("S".equals(response.getRspHead().getResponseStatus()) || "P".equals(response.getRspHead().getResponseStatus())) {
                        JSONObject saveOrder = new JSONObject();
                        saveOrder.put("f_out_trade_no", txnOrderId);
                        saveOrder.put("f_attach", attach);
                        saveOrder.put("f_order_state", "已下单");
                        saveOrder.put("f_order_type", orderType);
                        saveOrder.put("flag", "JsApiYongZhouH5");
                        saveOrder.put("f_trade_type", "H5PAY");
                        saveOrder.put("f_filiale", filiale);
                        saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                        saveOrder.put("f_userfiles_id", userfilesid);
                        saveOrder.put("f_trdate", trDate);
                        // 保存分公司id
                        JSONObject clientConfig = Config.getClientConfig(filiale);
                        saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                        logicServer.run("savewxreturnxml", saveOrder);
                        result.put("code", "200");
                        result.put("msg", "SUCCESS");
                        // 支付跳转链接
                        result.put("mweb_url", response.getRspBody().getRedirectUrl());
                        result.put("f_out_trade_no", txnOrderId);
                    } else {
                        result.put("code", response.getRspHead().getResponseCode());
                        result.put("error", "请求成功，H5下单失败，失败原因:" + response.getRspHead().getResponseMsg());
                    }
                } else {
                    result.put("code", response.getRspCode());
                    result.put("error", "请求失败，H5下单失败，失败原因:" + response.getRspMsg());
                }
            } catch (Exception e) {
                log.debug("请求响应错误");
                result.put("code", "500");
                result.put("result_msg", "请求响应错误");
                result.put("err_msg", e.getMessage());
                throw new RuntimeException("下单请求永州交行H5未正常响应");
            }
        } catch (Exception e) {
            log.debug("永州交行H5下单异常错误:{}", e.getMessage());
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        return jsApiYongZhou.orderStatus(value);
    }
    /**
     * 退款
     * {
     *   "f_total_fee": "1",
     *   "f_filiale": "yongzhou",
     *   "id":2514,
     *   "f_trdate": "20230922",
     *   "out_trade_no": "20230922waly0r5u08iwa1xwdwhz0qzg",
     *   "flag": "JsApiYongZhou"
     * }
     * @param json
     * @return 退款
     */
    @Override
    public String refund(JSONObject json) {
        return jsApiYongZhou.refund(json);
    }


    /**
     * 查询订单是否退款成功
     *
     * @param value
     * @return 订单退款结果
     */
    @Override
    public String refundOrderStatus(String value) {
        return jsApiYongZhou.refundOrderStatus(value);
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return jsApiYongZhou.getRecordFile(json);
    }
}
