SELECT
    *
FROM
    (
        SELECT
            b.id,
            u.f_userinfo_code,
            u.f_user_state,
            u.f_createfile_person,
            u.f_user_phone,
            u.f_comments,
            u.f_idnumber,
            u.f_balance,
            b.f_userinfo_id,
            b.f_open_id,
            b.f_band_state,
            b.f_user_name,
            b.f_address,
            u.f_orgid,
            u.f_orgname,
            u.f_depname,
            u.f_operator,
            u.f_depid,
            u.f_operatorid,
            u.f_createfile_date,
            g.f_meter_brand,
            g.f_meter_type,
            address.f_slice_area AS f_zones,
            address.f_residential_area,
            address.f_building,
            address.f_unit,
            address.f_floor,
            address.f_room,
            b.f_band_time
        FROM t_banduser b
                 LEFT JOIN t_userinfo u ON u.f_userinfo_id = b.f_userinfo_id
                 LEFT JOIN t_userfiles uf ON uf.f_userinfo_id = u.f_userinfo_id
                 LEFT JOIN t_gasbrand g ON uf.f_gasbrand_id = g.id
                 LEFT JOIN t_user_address address ON u.f_userinfo_id = address.f_userinfo_id
        WHERE
                f_band_state = '有效' and b.f_userinfo_id is not null and uf.f_table_state = '正常'
    ) t
WHERE
    {condition}
ORDER BY
    f_userinfo_code DESC
