package com.aote.util;

import org.json.JSONObject;

import java.util.Map;
import java.util.SortedMap;

/**
 * 微信支付工具类
 */
public class WXPayUtil {

    public static final String FAIL = "FAIL";
    public static final String SUCCESS = "SUCCESS";
    public static final String SYSTEMERROR = "SYSTEMERROR";
    public static final String BANKERROR = "BANKERROR";
    public static final String USERPAYING = "USERPAYING";

    /**
     * 向 Map 中添加 appid、mch_id、nonce_str、sign <br>
     * 该函数适用于商户适用于统一下单等接口，不适用于红包、代金券接口
     *
     * @param reqData
     * @param data    必须有{appId: xxx,mchId: xxx}
     * @return
     * @throws Exception
     */
    public static SortedMap<Object, Object> fillRequestData(SortedMap<Object, Object> reqData, JSONObject data) {
        reqData.put("appid", data.getString("f_appid"));
        reqData.put("mch_id", data.getString("f_mchid"));
        reqData.put("nonce_str", WxSign.getNonceStr());
        // 默认MD5
        reqData.put("sign", WxSign.createSign(reqData, data.getString("f_api_key")));
        return reqData;
    }

    /**
     * 处理 HTTPS API返回数据，转换成Map对象。return_code为SUCCESS时，返回数据
     *
     * @param xmlStr API返回的XML格式数据
     * @return Map类型数据
     * @throws Exception
     */
    public static Map<String, String> processResponseXml(String xmlStr) throws Exception {
        String RETURN_CODE = "return_code";
        String return_code;
        Map<String, String> respData = XmlUtils.xmlToMap(xmlStr);
        if (respData.containsKey(RETURN_CODE)) {
            return_code = respData.get(RETURN_CODE);
        } else {
            throw new Exception(String.format("No `return_code` in XML: %s", xmlStr));
        }
        if (return_code.equals(FAIL)) {
            throw new Exception("通讯失败:" + respData.get("return_msg"));
        } else if (return_code.equals(SUCCESS)) {
            return respData;
        } else {
            throw new Exception(String.format("return_code value %s is invalid in XML: %s", return_code, xmlStr));
        }
    }
}
