package com.aote.rs.wechatpay;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import com.aote.entity.WxNofityReturnData;
import com.aote.util.XmlUtils;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class PayFee {
	static Logger log = Logger.getLogger(PayFee.class);

	public static JSONObject xml(WxNofityReturnData reData) {
		try {
			JSONObject result = new JSONObject();
			result.put("f_return_code", reData.getResult_code());
			result.put("f_return_msg", reData.getReturn_msg());
			result.put("f_appid", reData.getAppid());
			result.put("f_mch_id", reData.getMch_id());
			result.put("f_device_info", reData.getDevice_info());
			result.put("f_nonce_str", reData.getNonce_str());
			result.put("f_sign", reData.getSign());
			result.put("f_result_code", reData.getResult_code());
			result.put("f_err_code", reData.getErr_code());
			result.put("f_err_code_des", reData.getErr_code_des());
			result.put("f_openid", reData.getOpenid());
			result.put("f_is_subscribe", reData.getIs_subscribe());
			result.put("f_trade_type", reData.getTrade_type());
			result.put("f_bank_type", reData.getBank_type());
			result.put("f_total_fee", reData.getTotal_fee());
			result.put("f_fee_type", reData.getFee_type());
			result.put("f_cash_fee", reData.getCash_fee());
			result.put("f_cash_fee_type", reData.getCash_fee_type());
			result.put("f_coupon_fee", reData.getCoupon_fee());
			result.put("f_coupon_count", reData.getCoupon_count());
			result.put("f_coupon_fee_0", reData.getCoupon_fee_0());
			result.put("f_coupon_id_0", reData.getCoupon_id_0());
			result.put("f_coupon_fee_1", reData.getCoupon_fee_1());
			result.put("f_coupon_id_1", reData.getCoupon_id_1());
			result.put("f_coupon_fee_2", reData.getCoupon_fee_2());
			result.put("f_coupon_id_2", reData.getCoupon_id_2());
			result.put("f_coupon_fee_3", reData.getCoupon_fee_3());
			result.put("f_coupon_id_3", reData.getCoupon_id_3());
			result.put("f_coupon_fee_4", reData.getCoupon_fee_4());
			result.put("f_coupon_id_4", reData.getCoupon_id_4());
			result.put("f_transaction_id", reData.getTransaction_id());
			result.put("f_out_trade_no", reData.getOut_trade_no());
			result.put("f_attach", reData.getAttach());
			result.put("f_time_end", reData.getTime_end());
			return result;
		} catch (Exception e) {
			log.debug("解析回调数据出错" + e.getMessage());
			throw new RuntimeException(e);
		}
	}

	// 转换返回数据
	public static WxNofityReturnData getNofityReturnData(InputStream is) {
		try {
			log.debug("解析微信支付回调数据");
			StringBuffer sb = new StringBuffer();
			InputStreamReader isr = new InputStreamReader(is, "UTF-8");
			BufferedReader br = new BufferedReader(isr);
			String s = "";
			while ((s = br.readLine()) != null) {
				sb.append(s);
			}
			String xml = sb.toString();
			log.debug("微信支付xml格式数据:" + xml);
			WxNofityReturnData reData = (WxNofityReturnData) XmlUtils.formatXml(xml, WxNofityReturnData.class);
			return reData;
		} catch (Exception e) {
			log.debug("解析微信支付回调数据出错" + e.getMessage());
			throw new RuntimeException(e);
		}

	}

	/**
	 * 把查询订单的数据包转换为可以保存中间表的数据
	 *
	 * @param value
	 * @return
	 */
	public static JSONObject conversionSave(String value) {
		JSONObject json = new JSONObject(value);
		JSONObject result = new JSONObject();
		result.put("id", json.opt("id"));
		result.put("f_return_code", json.opt("return_code"));
		result.put("f_return_msg", json.opt("return_msg"));
		result.put("f_appid", json.opt("appid"));
		result.put("f_mch_id", json.opt("mch_id"));
		result.put("f_nonce_str", json.opt("nonce_str"));
		result.put("f_sign", json.opt("sign"));
		result.put("f_result_code", json.opt("result_code"));
		result.put("f_err_code", json.opt("err_code"));
		result.put("f_err_code_des", json.opt("err_code_des"));
		result.put("f_device_info", json.opt("device_info"));
		result.put("f_openid", json.opt("openid"));
		result.put("f_is_subscribe", json.opt("is_subscribe"));
		result.put("f_trade_type", json.opt("trade_type"));
		result.put("f_trade_state", json.opt("trade_state"));
		result.put("f_bank_type", json.opt("bank_type"));
		result.put("f_total_fee", json.opt("total_fee"));
		result.put("f_settlement_total_fee", json.opt("settlement_total_fee"));
		result.put("f_fee_type", json.opt("fee_type"));
		result.put("f_cash_fee", json.opt("cash_fee"));
		result.put("f_cash_fee_type", json.opt("cash_fee_type"));
		result.put("f_coupon_fee", json.opt("coupon_fee"));
		result.put("f_coupon_count", json.opt("coupon_count"));
		result.put("f_coupon_fee_$n", json.opt("coupon_type_$n"));
		result.put("f_coupon_id_$n", json.opt("coupon_id_$n"));
		result.put("f_coupon_fee_$n", json.opt("coupon_fee_$n"));
		result.put("f_transaction_id", json.opt("transaction_id"));
		result.put("f_out_trade_no", json.opt("out_trade_no"));
		result.put("f_attach", json.opt("attach"));
		result.put("f_time_end", json.opt("time_end"));
		result.put("f_trade_state_desc", json.opt("trade_state_desc"));
		result.put("f_filiale", json.opt("f_filiale"));
		return result;
	}
	
}