package com.aote.rs.h5pay;


import java.math.BigDecimal;
import java.util.SortedMap;
import java.util.TreeMap;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.aote.entity.WxPayReturnData;
import com.aote.entity.WxPaySendData;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.WechatUrl;
import com.aote.util.WxSign;
import com.aote.util.XmlUtils;
import com.aote.weixin.Config;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * h5预付费处理
 */
@Component
public class H5Webpay implements PaySuper {

	static Logger log = Logger.getLogger(H5Webpay.class);

	@Autowired
	private LogicServer logicServer;
	

	/**
	 * 下单接口
	 * @param json
	 * @return 下单结果参数
	 */
	@Override
	public String prePay(JSONObject json) {
		JSONObject result = new JSONObject();
		try {
			String appId = json.getString("appId");
			String key = json.getString("key");
			String mchId = json.getString("mchId");
			String notifyUrl = json.getString("wechatNotify");
			String money = json.getString("money");
			String openid = json.getString("openid");
			String attach = json.getString("attach");
			String ip = json.getString("ip");
			String filiale = json.getString("filiale");
			String orderType = json.getString("orderType");
			String h5PayUrl = json.getString("h5PayUrl");

			log.debug("ip:" + ip);
			WxPaySendData sendData = getPaySendEntity(appId, mchId, money, attach, ip, notifyUrl, orderType, h5PayUrl);
			// 下单处理,返回数据为xml
			String returnXml = unifiedOrder(sendData, key);
			log.debug("returnXml=" + returnXml);
			WxPayReturnData reData = (WxPayReturnData) XmlUtils.formatXml(returnXml, WxPayReturnData.class);
			// 下单成功标识
			boolean checkoutSuccess = false;
			// 判断返回数据
			String return_code = reData.getReturn_code();
			if (return_code.equals("SUCCESS")) {
				if (!reData.getResult_code().equals("SUCCESS")) {
					result.put("error", "返回错误：" + reData.getErr_code()
							+ reData.getErr_code_des());
				} else {
					checkoutSuccess = true;
				}
			} else {
				result.put("error", "系统错误：" + reData.getReturn_msg());
			}
			if (checkoutSuccess) {
				// 保存下单信息到中间表
				JSONObject param = new JSONObject(attach);
				String userFilesId = param.optString("f_userfiles_id", "");

				JSONObject saveOrder = new JSONObject();
				saveOrder.put("f_out_trade_no", sendData.getOut_trade_no());
				saveOrder.put("f_attach", attach);
				saveOrder.put("f_openid", openid);
				saveOrder.put("f_total_fee", sendData.getTotal_fee());
				saveOrder.put("f_order_state", "已下单");
				saveOrder.put("f_order_type", orderType);
				saveOrder.put("flag", "H5Webpay");
				saveOrder.put("f_filiale", filiale);
				saveOrder.put("f_userfiles_id", userFilesId);
				// 保存分公司id
				JSONObject clientConfig = Config.getClientConfig(filiale);
				saveOrder.put("f_orgid", clientConfig.get("orgStr"));
				logicServer.run("savewxreturnxml", saveOrder);
			}
			// 跳转支付页面
			result.put("mweb_url", reData.getMweb_url());

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		log.debug("result=" + result);
		return result.toString();
	}

	public WxPaySendData getPaySendEntity(String appId,String mchId, String money, String attach,String ip,String url, String orderType, String h5PayUrl) {
		log.debug("weixin-start-h5pay" + ",money=" + money );
		WxPaySendData result = new WxPaySendData();
		// appid
		result.setAppid(appId);
		//商户id
		result.setMch_id(mchId);
		result.setNonce_str(WxSign.getNonceStr());
		result.setBody("微信公众号支付");
		result.setAttach(attach);
		// 随机数
		result.setOut_trade_no(WxSign.getNonceStr());
		BigDecimal v1 = new BigDecimal(money);
		BigDecimal v2 = new BigDecimal("100");
		Double b = v1.multiply(v2).doubleValue();
		int fee1 = b.intValue();
		result.setTotal_fee(fee1);
		// result.setTotal_fee((int) (Double.parseDouble(money) * 100));// 单位：分 支付金额
		// 订单生成的机器IP，指用户浏览器端IP
		result.setSpbill_create_ip(ip);
		// 支付完回调地址
		result.setNotify_url(url);
		// setTrade_type 交易类型 JSAPI--公众号支付、NATIVE--原生扫码支付、APP--app支付
		result.setTrade_type("MWEB");

		// 场景信息必传
		JSONObject re = new JSONObject();
		JSONObject r = new JSONObject();
		re.put("type", "Wap");
		re.put("wap_ur", h5PayUrl);
		re.put("wap_name", orderType);
		r.put("h5_info", re);
		result.setScene_info(r.toString());
		return result;
	}

	public static String unifiedOrder(WxPaySendData data, String key) {
		// 统一下单支付
		String returnXml = null;
		try {
			// 生成sign签名
			SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
			parameters.put("appid", data.getAppid());
			parameters.put("mch_id", data.getMch_id());
			parameters.put("nonce_str", data.getNonce_str());
			parameters.put("body", data.getBody());
			parameters.put("out_trade_no", data.getOut_trade_no());
			parameters.put("attach", data.getAttach());
			parameters.put("total_fee", (Integer) data.getTotal_fee());
			parameters.put("spbill_create_ip", data.getSpbill_create_ip());
			parameters.put("notify_url", data.getNotify_url());
			parameters.put("trade_type", data.getTrade_type());
			parameters.put("scene_info", data.getScene_info());
			data.setSign(WxSign.createSign(parameters, key));
			XStream xs = new XStream(new DomDriver("UTF-8",
					new XmlFriendlyNameCoder("-_", "_")));
			xs.alias("xml", WxPaySendData.class);
			String xml = xs.toXML(data);
			HttpClient httpClient = HttpClients.createDefault();
			HttpPost postRequest = new HttpPost(WechatUrl.DOWN_PAY_API);
			StringEntity postEntity = new StringEntity(xml, "UTF-8");
			postRequest.addHeader("Content-Type", "text/xml");
			postRequest.setEntity(postEntity);
			HttpResponse httpResponse = httpClient.execute(postRequest);
			HttpEntity entity = httpResponse.getEntity();
			if (entity != null) {
				returnXml = EntityUtils.toString(entity, "UTF-8");
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return returnXml;
	}

	/**
	 * 查询订单是否支付成功
	 *
	 * @param value
	 * @return 订单支付结果
	 */
	@Override
	public String orderStatus(String value) {
		log.debug("主动查询订单 >>> " + value);
		JSONObject jsonObject = new JSONObject(value);
		JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

		String appId = wxConfig.getString("appId");
		String mchId = wxConfig.getString("mchId");
		String key = wxConfig.getString("key");
		String nonceStr = WxSign.getNonceStr();
		// 签名
		SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
		parameters.put("appid", appId);
		parameters.put("mch_id", mchId);
		parameters.put("nonce_str", nonceStr);
		if (jsonObject.has("transaction_id")) {
			parameters.put("transaction_id", jsonObject.getString("transaction_id"));
		} else {
			parameters.put("out_trade_no", jsonObject.getString("out_trade_no"));
		}
		parameters.put("sign", WxSign.createSign(parameters, key));
		String requestXml = XmlUtils.getRequestXml(parameters);
		try {
			// 发送查询请求
			String returnXml = HttpUtil.post(WechatUrl.PAY_QUERY_API, requestXml, 60000);
			String xml = JSONUtil.parseFromXml(returnXml).get("xml").toString();
			log.debug("查询订单返回:" + xml);
			return xml;
		} catch (Exception e) {
			log.debug("查询订单出错:" + e);
			return "{}";
		}
	}

}
