package com.aote.pay.zx_liuan;

import com.aote.pay.PaySuper;
import com.aote.swiftpass.util.SignUtils;
import com.aote.swiftpass.util.XmlUtils;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.utils.SSLClient;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import com.aote.logic.LogicServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 六安中信对接下单接口
 */
@Slf4j
@Component
public class JsApiLiuAn implements PaySuper {

    private final static String version = "2.0";
    private final static String charset = "UTF-8";

    @Autowired
    private LogicServer logicServer;
    


    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        HttpServletRequest request = (HttpServletRequest) json.get("request");

        JSONObject result = new JSONObject();
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        try {
            // 接口类型
            String service = "pay.weixin.jspay";
            // 签名方式
            String signType = wxConfig.getString("signType");
            // 银行商户号
            String merchId = wxConfig.getString("merchId");
            // 原生JS,值为1
            String 	isRaw = "1";
            // 商户订单号
            String outTradeNo = WxSign.getNonceStr();
            // 商品描述
            String body = wxConfig.getString("body");
            // 公众账号或小程序ID
            String appId = wxConfig.getString("appId");
            // 订单金额，单位为分
            String totalFee = String.valueOf(PayUtil.yuan2FenInt(money));
            // 终端IP
            String mchCreateIp = request.getRemoteAddr();
            // 通知地址
            String notifyurl = wxConfig.getString("wechatNotify");
            // 随机字符串
            String nonceStr = WxSign.getNonceStr();


            // 私钥
            String mchPrivateKey = wxConfig.getString("mchPrivateKey");
            // 公钥
            String platPublicKey = wxConfig.getString("platPublicKey");
            // MD5key
            String secretKey = wxConfig.getString("secretKey");
            // 下单地址
            String payUrl = wxConfig.getString("payUrl");

            // 生成签名
            Map<String, String> parameters = new HashMap();
            parameters.put("service", service);
            parameters.put("mch_id", merchId);
            parameters.put("out_trade_no", outTradeNo);
            parameters.put("is_raw", isRaw);
            parameters.put("sub_openid", openid);
            parameters.put("sub_appid", appId);
            parameters.put("attach", attach);
            parameters.put("total_fee", totalFee);
            parameters.put("notify_url", notifyurl);
            parameters.put("nonce_str", nonceStr);
            parameters.put("body", body);
            parameters.put("mch_create_ip", mchCreateIp);
            parameters.put("sign_type", signType);
            parameters.put("version", version);
            parameters.put("charset", charset);
            String sign = com.aote.swiftpass.util.SignUtil.getSign(signType, SignUtils.payParamsToString(parameters), mchPrivateKey, secretKey);
            parameters.put("sign", sign);
            log.debug("六安威富通下单地址: {},下单参数: {}", payUrl, parameters);
            HttpClient httpclient = new SSLClient();
            HttpPost postRequest = new HttpPost(payUrl);
            postRequest.setEntity(new StringEntity(XmlUtils.toXml(parameters), "UTF-8"));
            HttpResponse httpResponse = httpclient.execute(postRequest);
            log.debug("httpResponse====>" + httpResponse.getStatusLine());
            int StatusCode = httpResponse.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                log.debug("威富通平台连接错误，错误代码:" + StatusCode);
                result.put("code", StatusCode);
                result.put("msg", "威富通平台连接错误，错误代码:" + StatusCode);
                return result.toString();
            }

            HttpEntity entity = httpResponse.getEntity();
            String rs = EntityUtils.toString(entity, "UTF-8");
            Map<String, String> reMap = XmlUtils.toMap(rs.getBytes("UTF-8"), "UTF-8");
            log.debug("status=" + StatusCode + ",同步返回结果: " + new JSONObject(reMap));
            if (!"0".equals(reMap.get("status"))) {
                log.debug("下单请求失败" + reMap.get("message"));
                result.put("code", 501);
                result.put("msg", "下单请求失败，失败原因:" + reMap.get("message"));
                return result.toString();
            }
            String signs = reMap.get("sign");
            String sign_type = reMap.get("sign_type");
            boolean check = com.aote.swiftpass.util.SignUtil.verifySign(signs, sign_type, reMap, platPublicKey, secretKey);
            log.debug("check" + check);
            if (!check) {
                log.debug("验签失败");
                result.put("code", 501);
                result.put("msg", "验签失败");
                return result.toString();
            }

            if ("0".equals(reMap.get("result_code"))) {
                // 保存下单信息到中间表
                JSONObject param = new JSONObject(attach);
                String userFilesId = param.optString("f_userfiles_id", "");

                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", outTradeNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("flag", "JsApiLiuAn");
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                saveOrder.put("f_userfiles_id", userFilesId);
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);


                result.put("code", 200);
                result.put("msg", "SUCCESS");
                result.put("f_out_trade_no", outTradeNo);
                JSONObject payInfo = new JSONObject(reMap.get("pay_info"));
                result.put("appId", payInfo.getString("appId"));
                result.put("timeStamp", payInfo.getString("timeStamp"));
                result.put("signType", payInfo.getString("signType"));
                result.put("package", payInfo.getString("package"));
                result.put("nonceStr", payInfo.getString("nonceStr"));
                result.put("paySign", payInfo.getString("paySign"));

            } else {
                log.debug("下单申请失败：" + reMap.get("err_msg"));
                result.put("code", 501);
                result.put("msg", "下单申请失败，失败原因:" + reMap.get("err_msg"));
                return result.toString();
            }

        } catch (Exception var17) {
            log.debug("下单异常，异常内容：" + var17.getMessage());
            result.put("code", 500);
            result.put("msg", "下单异常，异常内容：" + var17.getMessage());
        }

        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 接口类型
            String service = "unified.trade.query";
            // 签名方式
            String signType = wxConfig.getString("signType");
            // 银行商户号
            String merchId = wxConfig.getString("merchId");
            //订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 随机字符串
            String nonceStr = WxSign.getNonceStr();

            // 私钥
            String mchPrivateKey = wxConfig.getString("mchPrivateKey");
            // 公钥
            String platPublicKey = wxConfig.getString("platPublicKey");
            // MD5key
            String secretKey = wxConfig.getString("secretKey");
            // 下单地址
            String queryUrl = wxConfig.getString("queryUrl");

            // 签名
            Map<String, String> parameters = new HashMap();
            parameters.put("service", service);
            parameters.put("sign_type", signType);
            parameters.put("mch_id", merchId);
            parameters.put("out_trade_no", outTradeNo);
            parameters.put("nonce_str", nonceStr);
            parameters.put("version", version);
            parameters.put("charset", charset);
            String sign = com.aote.swiftpass.util.SignUtil.getSign(signType, SignUtils.payParamsToString(parameters), mchPrivateKey, secretKey);
            parameters.put("sign", sign);
            log.debug("六安威富通查询地址: {},查询参数: {}", queryUrl, parameters);
            HttpClient httpclient = new SSLClient();
            HttpPost postRequest = new HttpPost(queryUrl);
            postRequest.setEntity(new StringEntity(XmlUtils.toXml(parameters), "UTF-8"));
            HttpResponse httpResponse = httpclient.execute(postRequest);
            log.debug("httpResponse==query==>" + httpResponse.getStatusLine());
            int StatusCode = httpResponse.getStatusLine().getStatusCode();
            if (StatusCode != 200) {
                log.debug("连接错误，错误代码:" + StatusCode);
                result.put("code", StatusCode);
                result.put("msg", "威富通平台连接错误，错误代码:" + StatusCode);
                return result.toString();
            }
            HttpEntity entity = httpResponse.getEntity();
            String rs = EntityUtils.toString(entity, "UTF-8");
            Map<String, String> reMap = XmlUtils.toMap(rs.getBytes("UTF-8"), "UTF-8");
            log.debug("status=" + StatusCode + ",同步返回结果: " + new JSONObject(reMap));
            if (!"0".equals(reMap.get("status"))) {
                log.debug("查询请求失败" + reMap.get("message"));
                result.put("code", 501);
                result.put("msg", "查询请求失败，失败原因:" + reMap.get("message"));
                return result.toString();
            }
            String signs = reMap.get("sign");
            String sign_type = reMap.get("sign_type");
            boolean check = com.aote.swiftpass.util.SignUtil.verifySign(signs, sign_type, reMap, platPublicKey, secretKey);
            log.debug("check" + check);
            if (!check) {
                log.debug("验签失败了");
                result.put("code", 501);
                result.put("msg", "验签失败");
                return result.toString();
            }

            if ("0".equals(reMap.get("result_code")) && "SUCCESS".equals(reMap.get("trade_state"))) {
                result.put("result_code", "SUCCESS");
                result.put("trade_state", "SUCCESS");
                // 订单号
                result.put("transaction_id", reMap.get("transaction_id"));
                // 交易日期
                result.put("time_end", reMap.get("time_end"));
                // 交易金额
                result.put("total_fee", reMap.get("total_fee"));
            } else {
                result.put("result_code", "FAIL");
                result.put("return_msg", reMap.get("err_msg"));
                log.debug("订单状态不等于已支付：" + reMap.get("trade_state"));
            }

        } catch (Exception e) {
            log.error("操作失败：原因" + e.getMessage());
            result.put("error", "系统异常");
        }
        return result.toString();
    }


}
