package com.aote.pay.boc.yongzhou;

import com.alibaba.fastjson.JSON;
import com.bocom.api.BocomApiException;
import com.bocom.api.BocomResponse;
import com.bocom.api.utils.BocomDigest;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.File;

public class DownloadNewPosStmtResponseV1 extends BocomResponse {
    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
    @JsonProperty("file_hashcode")
    private String fileHashcode;

    @JsonProperty("file_name")
    private String fileName;

    private String filePath;

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileHashcode() {
        return fileHashcode;
    }

    public void setFileHashcode(String fileHashcode) {
        this.fileHashcode = fileHashcode;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public boolean isSuccess() {
        if (!super.isSuccess()) {
            return false;
        }
        if (!filePath.endsWith("/") || !filePath.endsWith("\\")) {
            filePath = filePath + "/";
        }
//        String tempFileName = fileName + ".TMP";
        File file = new File(filePath );
        try {
            String fileHashcode = BocomDigest.fileDigest(filePath );
            if (!fileHashcode.equals(this.fileHashcode)) {
                file.delete();
                throw new BocomApiException("Bocom fileHashCode digest not passed.");
            }
            file.renameTo(new File(filePath + fileName));
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}
