package com.aote.webmeter.tools.tcp;

import com.af.plugins.ConvertTools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

/**
 * TCP通讯工具
 */
public class TcpTools {
    /**
     *TCP管道
     */
    private static final ThreadLocal<SocketChannel> CHANNEL_THREAD_LOCAL = new ThreadLocal<>();

    public static void set(SocketChannel channel) {
        CHANNEL_THREAD_LOCAL.set(channel);
    }

    public static SocketChannel get() {
        return CHANNEL_THREAD_LOCAL.get();
    }

    /**
     * 发送消息
     * @param message 消息体
     * @return 成功
     */
    public static boolean send(String message) throws IOException {
        ByteBuffer outBuffer;
        outBuffer = ByteBuffer.wrap(ConvertTools.base64Decode(message.getBytes()));
        CHANNEL_THREAD_LOCAL.get().write(outBuffer);
        return true;
    }
}
