package com.aote.webmeter.module.saifunb;

import org.json.JSONArray;
import org.json.JSONObject;
import java.text.DecimalFormat;
import java.util.Iterator;

/**
 * 流量值处理类
 */
public class FlowCurve {

    /** 表一天的数据
     * 根据clob内容取key值和value值存入到对应的json中，最后将json放入到一个大的jsonArray返回
     * @param content
     * @return
     */
    public JSONObject getJsonDat(String content) {
        JSONObject jo = new JSONObject();
        JSONArray jsonArray = new JSONArray(content);
        String[] equalstr = {"00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15",
                "16","17","18","19","20","21","22","23"};
        double[] valueArray = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
        for(int i = 0; i < equalstr.length; i++) {
            double sum = 0.0;
            for(int j = 0; j < jsonArray.length(); j++) {
                JSONObject jsonObject = (JSONObject) jsonArray.get(j);
                Iterator<String> keys = jsonObject.keys();
                String dataKey = "";
                double dataValue = 0.0;
                while(keys.hasNext()) {
                    // 拿到key值
                    dataKey = keys.next();
                    if(dataKey.startsWith(equalstr[i])) {
                        dataValue = Double.parseDouble(jsonObject.get(dataKey).toString());
                        // 累加某个时间段内的值
                        sum += dataValue;
                        System.out.println(sum);
                    }
                }
            }
            DecimalFormat df = new DecimalFormat("#.00");
            String valueStr =df.format(sum);
            sum = Double.parseDouble(valueStr);
            System.out.println(sum);
            valueArray[i] = sum;
        }
        jo.put("date", equalstr);
        jo.put("value", valueArray);
        return jo;
    }

    /**
     * 获取某块表一天的数据
     * @param clobValue
     * @return
     */
    public JSONArray getClobData(String clobValue) {
        if("".equals(clobValue)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        System.out.println("clob字符串：" + clobValue);
        JSONObject jsonDat = getJsonDat(clobValue);
        // 取第一天的数据
        System.out.println(jsonDat.toString());
        System.out.println("已经结束");
        //将一天的数据放入jsonArray中
        jsonArray.put(jsonDat);
        return jsonArray;
    }
    /**
     * 转换clob字段值
     * @param query
     * @return
     */
    public String getClobValue(JSONArray query) {
        if(query != null && query.length() > 0) {
            try {
                Object object = query.getJSONObject(0).get("f_flow_curve_value");
                if (object instanceof java.sql.Clob) {
                    java.sql.Clob sc = (java.sql.Clob) object;
                    long len = sc.length();
                    System.out.println(len);
                    String str = sc.getSubString(1,(int)len);
                    System.out.println(str);
                    return str;
                } else {
                    return "";
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }
}
