package com.aote.webmeter.module.BaoJianSystem;

import com.af.plugins.CommonTools;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author xumeng
 * @date 2020/4/13 10:43
 */
public class BaoJianTools {
    /**
     * 证件类型
     */
    public String getIdentityType(String str) {
        String typeCode = null;
        switch (str) {
            case "102501":
                typeCode = "身份证";
                break;
            case "102502":
                typeCode = "护照";
                break;
            case "102503":
                typeCode = "台湾通行证";
                break;
            case "102504":
                typeCode = "港澳通行证";
                break;
            case "102505":
                typeCode = "军官证";
                break;
            case "102506":
                typeCode = "营业执照";
                break;
            default:
                System.out.println("您输入的类型有误");
                break;
        }
        return typeCode;
    }

    /**
     *签名算法
     */
    public static String randomKey = "";

    public static String createSign(JSONObject object) {
        String preSignStr = createLinkString(object);
        return CommonTools.md5(preSignStr + "&key=" + randomKey).toUpperCase();
    }

    public static String createSign(JSONObject object, String paternerKey) {
        String preSignStr = createLinkString(object);
        return CommonTools.md5(preSignStr + "&key=" + paternerKey).toUpperCase();
    }

    public static String createLinkString(JSONObject params) {
        List<String> keys = new ArrayList(params.keySet());
        //按照字典排序
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        for (String key : keys) {
            String value = String.valueOf(params.get(key));
            if (!StringUtils.isBlank(value)) {
                prestr.append(key).append("=").append(value).append("&");
            }
        }
        prestr = new StringBuilder(prestr.substring(0, prestr.length() - 1));
        return prestr.toString();
    }
}
