package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 通用参数类型
 * @author Mr.river
 */
public enum WebmeterPropertiesEnum {

    //气表品牌别名
    METER_ALIAS("meterBrandName"),
    //数据源类型
    DATA_SOURCE_TYPE("dataSource"),
    //营收系统版本名称
    SALE_NAME("saleName");

    private final String value;

    WebmeterPropertiesEnum(String value) {
        this.value = value;
    }

    public static WebmeterPropertiesEnum toType(String value) {
        return Stream.of(WebmeterPropertiesEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
