package com.aote.webmeter.enums;

/**
 * 物联网表 通用错误码
 *
 * @author Mr.river
 */
public enum WebmeterExceptionCodeEnum {
    //物联网表配置文件异常
    CONFIG_FAIL(
            "ES1",
            "获取物联网表模块配置文件失败",
            "请检查模块下是否包含webmeter.properties配置文件"
    ),
    //未找到物联网表模块异常
    MODULE_NOT_FIND_FAIL(
            "ES2",
            "未找到此物联网表模块",
            "请检查物联网表模块名是否配置正确"
    ),
    //未找到对应营收版本异常
    SALE_VERSION_NOT_FIND_FAIL(
            "ES3",
            "未找到此营收版本",
            "请检查webmeter.properties配置文件中营收版本是否配置正确"
    ),
    //营收版本未配置异常
    SALE_VERSION_NULL_FAIL(
            "ES4",
            "营收版本未配置",
            "请配置webmeter.properties配置文件中的营收版本参数"
    );

    private final String code;
    private final String name;
    private final String message;

    WebmeterExceptionCodeEnum(String code, String name, String message) {
        this.code = code;
        this.name = name;
        this.message = message;
    }


    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getMessage() {
        return message;
    }
}
