select  * from(
	select
		s.f_user_type,		--用户类型
		s.f_gasproperties,	--用气性质
		s.f_gasproperties2,	--用气属性
		s.f_filiale,			--分公司
		h1.f_balance,		--期初余额(元)
		h1.f_last_tablebase,--上期读数
		h2.f_tablebase,		--本期读数
		s.f_oughtamount,	--用气气量(m2)
		s.min_oughtamount,--最小日用气量
		s.max_oughtamount,--最大日用气量
		s.f_oughtfee,		--用气金额(元)
		Convert(decimal(18,2),s.f_oughtfee/(case when s.f_oughtamount = 0 then 1 else s.f_oughtamount end)) f_avg_price,--平均单价(元/m2)
		h2.f_curbalance,	--期末结余(元)
		convert(varchar(11),h1.f_hand_date,23) f_last_hand_date,--期初上报日期
		convert(varchar(11),h2.f_hand_date,23) f_end_hand_date,--期末上报日期
		case when s.f_gasproperties2 like '%生产%' then '工业生产'
			when s.f_gasproperties2 like '%取暖%' then '取暖'
			else '其他' end s
	from(
		select
		  uf.f_user_type,
		  uf.f_gasproperties,
		  uf.f_gasproperties2,
		  uf.f_filiale,
		  min(h.id) minid,
		  max(h.id) maxid,
		  max(f_oughtamount) max_oughtamount,
		  min(f_oughtamount) min_oughtamount,
		  sum(f_oughtamount) f_oughtamount,
		  sum(f_oughtfee) f_oughtfee
		from t_handplan h
		left join t_userfiles uf on h.f_user_id=uf.f_user_id
		left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
		LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
	  where f_oughtamount>=0 and h.f_hand_date>='{startDate}' and h.f_hand_date<='{endDate}'
	  group by
		  uf.f_user_type,
		  uf.f_gasproperties,
		  uf.f_gasproperties2,
		  uf.f_filiale
	) s left join t_handplan h1 on s.minid=h1.id
		left join t_handplan h2 on s.maxid=h2.id
) s
order by s.f_filiale desc
