-- 公共SQL：积成-查询待开户的表具信息
-- 必选参数
-- f_meter_brand：气表品牌名称，如青岛积成等

SELECT
			 i.f_residential_area area_name,-- 不存在或者未填写
			 i.f_user_name customer_name,
			 i.f_address address,
			 i.f_createfile_date create_date,
			 i.f_user_phone phone,
			 i.f_user_type customer_type,
			 u.f_user_id customer_code,
			 u.f_initial_base start_val,
			 i.f_price_id use_nature,
			 m.f_metertype meter_type_name, -- 不存在或者未填
			 m.f_terminal_id terminal_name, -- 对应的设备不存在
			 m.f_iot_type channel_type,
			 m.f_diameter caliber,
			 m.f_meter_phone meter_phone,
			 m.f_meternumber steal_no,
			 m.f_valvemark switch_op,
			 m.f_telecomm_no telecomm_sn,
			 m.f_imei imei,
			 m.f_imsi iccid,
			 m.f_vender vender,
			 i.f_filialeids filialeids
FROM
		 t_userfiles u
			 LEFT JOIN t_userinfo i ON u.f_userinfo_id = i.f_userinfo_id
			 LEFT JOIN t_meterinfo m ON u.f_meternumber = m.f_meternumber
			 LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
WHERE
		(u.f_sendsuccess <> '成功' OR u.f_sendsuccess IS NULL)
	AND b.f_alias in ({f_meter_brand})
	AND u.f_table_state != '停用'
	AND i.f_user_state = '正常'