select t,types,{groupname},usertotal FROM(
	SELECT
		SUM(s) t,                        --异常总数
		SUM(types) types,                --抄表异常
		SUM(usertotal) usertotal,		 --异常用户数
		{groupname}
	FROM(
		SELECT year,month,week,day,f_filiale,
					f_error_level,f_meternumber,f_userinfo_id,
					SUM(s) s,                        --异常总数
					1 usertotal,
					SUM({grouptype}) types
		FROM (
			SELECT 1 s,
				convert(varchar(4),e.f_insert_date,23)+'年' year,
				convert(varchar(7),e.f_insert_date,23) month,
				cast(Datename(week,e.f_insert_date) as varchar)+'周'  week,
				convert(varchar(50),e.f_insert_date,23) day,
				case when e.f_error_type='抄表异常' then 1 else 0 end type1,
				case when e.f_error_type='信号质量差' then 1 else 0 end type2,
				case when e.f_error_type='电压低' then 1 else 0 end type3,
				case when e.f_error_type='磁干扰' then 1 else 0 end type4,
				case when e.f_error_type='报警关阀' then 1 else 0 end type5,
				case when e.f_error_type='周期关阀' then 1 else 0 end type6,
				case when e.f_error_type='过流保护关阀' then 1 else 0 end type7,
				case when e.f_error_type='关阀走气' then 1 else 0 end type8,
				case when e.f_error_type='拆表报警' then 1 else 0 end type9,
				case when e.f_error_type='E-7单干簧管故障' then 1 else 0 end type10,
				case when e.f_error_type='E-8双干簧管故障' then 1 else 0 end type11,
				case when e.f_error_type='E-16周期关阀' then 1 else 0 end type12,
				case when e.f_error_type='E-17过流报警' then 1 else 0 end type13,
				case when e.f_error_type='E-21透支关阀' then 1 else 0 end type14,
				case when e.f_error_type='E-23透支过气' then 1 else 0 end type15,
				f.f_filiale,e.f_error_level,LEFT(f.f_meternumber, 4) f_meternumber,
				f.f_userinfo_id
			FROM t_exception e
			LEFT JOIN t_userfiles f on f.f_user_id=e.f_user_id
			LEFT JOIN t_userinfo u on f.f_userinfo_id=u.f_userinfo_id
			where e.f_insert_date >= '{startDate}' and e.f_insert_date <= '{endDate}'
			    and {condition}
			GROUP BY e.f_error_type,f.f_filiale,f.f_meternumber,e.f_insert_date,e.f_error_level,f.f_userinfo_id
		) t
		WHERE {grouptype}=1
		GROUP BY year,month,week,day,f_filiale,f_error_level,f_meternumber,f_userinfo_id
	) t
	GROUP BY {groupname}
) t
ORDER BY t