/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.kashi;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.af.plugins.RestTools;
import com.af.plugins.iot.WebMeterInfo;
import com.aote.sql.SqlServer;
import com.aote.webmeter.module.kashi.KaShiInfo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class KaShiSettlementTools {
    private static Logger log = Logger.getLogger(KaShiSettlementTools.class);
    @Autowired
    private SqlServer sqlServer;

    public void getData() throws Exception {
        WebMeterInfo.setModuleName((String)"KaShi");
        ConcurrentHashMap<String, JSONArray> data = new ConcurrentHashMap<String, JSONArray>();
        log.info((Object)"\u67e5\u8be2\u8c03\u4ef7\u8be6\u7ec6\u4fe1\u606f");
        JSONArray paramArray = this.sqlServer.query("KaShiGetChangePriceInfo", new JSONObject());
        for (int i = 0; i < paramArray.length(); ++i) {
            JSONObject items = paramArray.getJSONObject(i);
            String meterNumber = items.getString("f_meternumber");
            if (!data.containsKey(meterNumber)) {
                data.put(meterNumber, new JSONArray().put((Object)items));
                continue;
            }
            ((JSONArray)data.get(meterNumber)).put((Object)items);
        }
        log.info((Object)"\u67e5\u8be2\u8c03\u4ef7\u8be6\u7ec6\u4fe1\u606f\u5b8c\u6210");
        if (DateTools.getNow((String)"yyyy-MM").equals("12-31")) {
            log.info((Object)"\u67e5\u8be2\u8de8\u5e74\u5f02\u5e38\u4fe1\u606f");
            JSONArray priceChangeMeterInfo = this.sqlServer.query("KaShiGetChangeUsersInfo", new JSONObject());
            for (int i = 0; i < priceChangeMeterInfo.length(); ++i) {
                JSONObject items = priceChangeMeterInfo.getJSONObject(i);
                items.put("id", (Object)CommonTools.getUUID());
                String meterNumber = items.getString("f_meternumber");
                if (data.containsKey(meterNumber)) continue;
                paramArray.put((Object)items);
                data.put(meterNumber, new JSONArray().put((Object)items));
            }
        }
        log.info((Object)"\u653e\u5165\u5185\u5b58\u6570\u636e\u5e93\u4e2d");
        KaShiInfo.setData(data);
        if (data.size() > 0) {
            log.info((Object)"\u8c03\u7528\u79ef\u6210\u63a5\u53e3");
            String ip = "http://192.168.4.11:18080/ws/rs/getDailyDatas";
            RestTools.post((String)ip, (String)paramArray.toString());
        }
    }

    public JSONArray settlement(JSONObject obj) {
        String meterNumber;
        ConcurrentHashMap data = KaShiInfo.getData();
        if (data.containsKey(meterNumber = obj.getString("steal_no"))) {
            JSONArray array = (JSONArray)data.remove(meterNumber);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject priceInfo = array.getJSONObject(i);
                JSONObject params = obj.getJSONObject(priceInfo.getString("begin_date"));
                params.put("steal_no", (Object)meterNumber);
                params.put("priceInfo", (Object)priceInfo);
                RestTools.post((String)"http://127.0.0.1:8845/webmeter/rs/logic/KaShiHistorySettlement", (JSONObject)params);
            }
        }
        JSONObject params = obj.getJSONObject(DateTools.getNow((String)"yyyy-MM-dd"));
        params.put("steal_no", (Object)meterNumber);
        return new JSONArray(RestTools.post((String)"http://127.0.0.1:8845/webmeter/rs/logic/KaShiHistorySettlement", (JSONObject)params));
    }

    public Boolean checkDataFromKey(String meterNumber) {
        ConcurrentHashMap data = KaShiInfo.getData();
        if (data.containsKey(meterNumber)) {
            String ip = "http://192.168.4.11:18080/ws/rs/getDailyDatas";
            RestTools.post((String)ip, (String)new JSONArray().put(data.get(meterNumber)).toString());
            return true;
        }
        return false;
    }
}

