SELECT * from(
		SELECT
			{groupname} f_parameter_date,
			SUM({types}) type1,									--待处理所选异常
			SUM(c{types}) ctype1								--已处理所选异常
		FROM(
			SELECT
				convert(varchar(4),p.f_parameter_date,23)+'年' year,
				convert(varchar(7),p.f_parameter_date,23) month,
				cast(Datename(week,p.f_parameter_date) as int)  week,
				convert(varchar(50),p.f_parameter_date,23) day,
				case when p.f_parameter_name='频繁磁干扰' and p.f_parameter_state='待处理' then 1 else 0 end type1,
				case when p.f_parameter_name='频繁间断性失联' and p.f_parameter_state='待处理' then 1 else 0 end type2,
				case when p.f_parameter_name='频繁指令下发失败' and p.f_parameter_state='待处理' then 1 else 0 end type3,
				case when p.f_parameter_name='锂电低电' and p.f_parameter_state='待处理' then 1 else 0 end type4,
				case when p.f_parameter_name='频繁拆表报警' and p.f_parameter_state='待处理' then 1 else 0 end type5,
				case when p.f_parameter_name='未装电池' and p.f_parameter_state='待处理' then 1 else 0 end type6,
				case when p.f_parameter_name='e7单干簧管故障' and p.f_parameter_state='待处理' then 1 else 0 end type7,
				case when p.f_parameter_name='e8双干簧管故障' and p.f_parameter_state='待处理' then 1 else 0 end type8,
				case when p.f_parameter_name='关阀过气' and p.f_parameter_state='待处理' then 1 else 0 end type9,
				case when p.f_parameter_name='液晶显示不全' and p.f_parameter_state='待处理' then 1 else 0 end type10,
				case when p.f_parameter_name='频繁报过流保护关阀' and p.f_parameter_state='待处理' then 1 else 0 end type11,
				case when p.f_parameter_name='负值故障' and p.f_parameter_state='待处理' then 1 else 0 end type12,
				case when p.f_parameter_name='其他' and p.f_parameter_state='待处理' then 1 else 0 end type13,
				case when p.f_parameter_name='频繁磁干扰' and p.f_parameter_state='-处理-' then 1 else 0 end ctype1,
				case when p.f_parameter_name='频繁间断性失联' and p.f_parameter_state='-处理-' then 1 else 0 end ctype2,
				case when p.f_parameter_name='频繁指令下发失败' and p.f_parameter_state='-处理-' then 1 else 0 end ctype3,
				case when p.f_parameter_name='锂电低电' and p.f_parameter_state='-处理-' then 1 else 0 end ctype4,
				case when p.f_parameter_name='频繁拆表报警' and p.f_parameter_state='-处理-' then 1 else 0 end ctype5,
				case when p.f_parameter_name='未装电池' and p.f_parameter_state='-处理-' then 1 else 0 end ctype6,
				case when p.f_parameter_name='e7单干簧管故障' and p.f_parameter_state='-处理-' then 1 else 0 end ctype7,
				case when p.f_parameter_name='e8双干簧管故障' and p.f_parameter_state='-处理-' then 1 else 0 end ctype8,
				case when p.f_parameter_name='关阀过气' and p.f_parameter_state='-处理-' then 1 else 0 end ctype9,
				case when p.f_parameter_name='液晶显示不全' and p.f_parameter_state='-处理-' then 1 else 0 end ctype10,
				case when p.f_parameter_name='频繁报过流保护关阀' and p.f_parameter_state='-处理-' then 1 else 0 end ctype11,
				case when p.f_parameter_name='负值故障' and p.f_parameter_state='-处理-' then 1 else 0 end ctype12,
				case when p.f_parameter_name='其他' and p.f_parameter_state='-处理-' then 1 else 0 end ctype13
			from t_userparameter p
			INNER JOIN t_userfiles AS f ON p.f_meternumber = f.f_meternumber
			INNER JOIN t_userinfo AS u ON f.f_userinfo_id = u.f_userinfo_id
			where f_parameter_state!='处理完成' and {condition}
		) s
	GROUP BY {groupname}
) s
ORDER BY f_parameter_date