-- 查询某一天到现在有过关阀跑气状态的表具
select
	u.*,
	m.c,
	m.idstr,
	m.min_meteread_id,
	m.min_hand_date,
	'关阀跑气:条数'  + cast(m.c as varchar) + ' | 初始异常日期' + m.min_hand_date   f_beizhu
from (
	select
		ui.f_userinfo_id,				                            --用户编号
		uf.f_user_id,						                            --表编号
		uf.f_meternumber,				                            --表号
		ui.f_user_name,					                            --用户名
		ui.f_address,						                            --用户地址
		ui.f_address_detail,		                            --用户地址(针对非民用)
		ui.f_user_type,                                     --用户类型
		ui.f_gasproperties,                                 --用气性质
		uf.f_balance_amount f_balance,                                       --账户结余
		ui.f_area,                                          --辖区
		ui.f_slice_area,                                    --片区
		uf.f_input_date,
		ui.f_street,                                        --街道
		ui.f_residential_area,                              --小区
		ISNULL(uf.f_position,'未知') AS f_position,					--表安装位置
		gb.id AS f_gasbrand_id,	                            --品牌识别列
		gb.f_meter_brand,				                            --气表品牌
		gm.id AS f_gasmodel_id,	                            --型号识别列
		gm.f_meter_style,				                            --气表型号
		gb.f_meter_type,				                            --气表类型
		uf.f_table_state,				                            --气表状态
		gb.f_alias,                                         --表厂别名
		uf.f_meter_base,				                            --气表底数
		ISNULL(uf.f_total_usegas_amount,0) AS f_total_usegas_amount, --表累购金额
		ISNULL(uf.f_valve_state,'未知') AS f_valve_state, 		--阀门状态
		uf.f_gas_date,
		ui.f_createfile_date,                               --建档日期
		ui.f_filialeids,
		uf.f_filiale,                               --分公司代号
        uf.f_outlets
	from
		t_userfiles uf
		LEFT JOIN t_userinfo ui ON (ui.f_userinfo_id= uf.f_userinfo_id)
		LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
		LEFT JOIN t_gasmodel gm ON (uf.f_gasmodel_id= gm.id)
		where  uf.f_meter_classify = '物联网表'
) u left join (
	select
		f_user_id,
		(select cast(id as varchar)+',' from t_meteread where f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
	      and f_valveState = 1 and f_leakageflag = 1 and f_user_id = m.f_user_id for xml path('')) idstr,
		CONVERT(varchar(100), min(f_hand_date), 20) min_hand_date,
		cast(min(id) as varchar) min_meteread_id,
		count(*) c
	from t_meteread m
	where f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
	      and f_valveState = 1 and f_leakageflag = 1
	group by f_user_id
) m on u.f_user_id = m.f_user_id
where m.c is not null
order by f_user_id desc
