-- 查询失联用户记录
-- 判断依据：开户日期到查询结束日期间隔天数 减去 期间上报天数比较
select
	u.*,
	m.c, -- 期间上报条数
	m.max_hand_date, --期间最后上报日期
	m.f_pregas,         --期间合计上报量
	gasdate_number-isnull(handdate_number,0) shilian, --失联天数
	'未用详情:上报条数'  + cast(m.c as varchar) + '|用气天数' + cast((gasdate_number-isnull(handdate_number,0)) as varchar) + '|用气量' + cast(m.f_pregas as varchar)  f_beizhu
from (
	select
		ui.f_userinfo_id,				                    --用户编号
		uf.f_user_id,						                --表编号
		uf.f_meternumber,				                    --表号
		ui.f_user_name,					                    --用户名
		ui.f_address,						                --用户地址
		ui.f_address_detail,		                        --用户地址(针对非民用)
		ui.f_user_type,                                     --用户类型
		ui.f_gasproperties,                                 --用气性质
		uf.f_balance_amount f_balance,                                       --账户结余
		ui.f_area,                                          --辖区
		ui.f_slice_area,                                    --片区
		uf.f_input_date,
		ui.f_street,                                        --街道
		ui.f_residential_area,                              --小区
		ISNULL(uf.f_position,'未知') AS f_position,			--表安装位置
		gb.id AS f_gasbrand_id,	                            --品牌识别列
		gb.f_meter_brand,				                    --气表品牌
		gm.id AS f_gasmodel_id,	                            --型号识别列
		gm.f_meter_style,				                    --气表型号
		gb.f_meter_type,				                    --气表类型
		uf.f_table_state,				                    --气表状态
		gb.f_alias,                                         --表厂别名
		uf.f_meter_base,				                            --气表底数
		ISNULL(uf.f_total_usegas_amount,0) AS f_total_usegas_amount, --表累购金额
		ISNULL(uf.f_valve_state,'未知') AS f_valve_state, 		--阀门状态
		ui.f_createfile_date,                               --建档日期
		uf.f_gas_date,
		ui.f_filialeids,
		uf.f_filiale,                   --分公司代号
        uf.f_outlets,
		case when f_gas_date>='{startDate}' then
		datediff(day,f_gas_date,'{endDate}') else datediff(day,'{startDate}','{endDate}')
		end gasdate_number
	from
		t_userfiles uf
		LEFT JOIN t_userinfo ui ON (ui.f_userinfo_id= uf.f_userinfo_id)
		LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
		LEFT JOIN t_gasmodel gm ON (uf.f_gasmodel_id= gm.id)
		where  uf.f_meter_classify = '物联网表'
) u left join (
	select
		f_user_id,
		count(*) handdate_number,
		max(f_hand_date) max_hand_date,
		sum(c) c,
		sum(f_pregas) f_pregas
	from (
		select
			f_user_id,
			CONVERT(varchar(100), f_hand_date,23) f_hand_date,
			sum(f_tablebase-f_last_tablebase) f_pregas,
			count(*) c
		from t_meteread
		where f_hand_date>='{startDate}' and f_hand_date<='{endDate}'
		group by f_user_id, CONVERT(varchar(100), f_hand_date,23)
	) m group by f_user_id
) m on u.f_user_id = m.f_user_id
where f_pregas=0 and gasdate_number=handdate_number  and {condition}
order by f_user_id desc