SELECT
		f_insert_date,{grouptype} types,{grouptype}_lv type_lv
FROM(
	SELECT
		SUM(s) t,                        --异常总数
		SUM(type1) type1,                --抄表异常
		Convert(decimal(18,2),(SUM(type1)/(sum(s)*1.00))*100) type1_lv, --抄表异常率
		SUM(type2) type2,                --信号质量差
		Convert(decimal(18,2),(SUM(type2)/(sum(s)*1.00))*100) type2_lv, --信号质量差率
		SUM(type3) type3,                --电压低
		Convert(decimal(18,2),(SUM(type3)/(sum(s)*1.00))*100) type3_lv, --电压低率
		SUM(type4) type4,                --磁干扰
		Convert(decimal(18,2),(SUM(type4)/(sum(s)*1.00))*100) type4_lv, --磁干扰率
		SUM(type5) type5,                --报警关阀
		Convert(decimal(18,2),(SUM(type5)/(sum(s)*1.00))*100) type5_lv, --报警关阀率
		SUM(type6) type6,                --周期关阀
		Convert(decimal(18,2),(SUM(type6)/(sum(s)*1.00))*100) type6_lv, --周期关阀率
		SUM(type7) type7,                --过流保护关阀
		Convert(decimal(18,2),(SUM(type7)/(sum(s)*1.00))*100) type7_lv, --过流保护关阀率
		SUM(type8) type8,                --关阀走气
		Convert(decimal(18,2),(SUM(type8)/(sum(s)*1.00))*100) type8_lv, --关阀走气率
		SUM(type9) type9,                --拆表报警
		Convert(decimal(18,2),(SUM(type9)/(sum(s)*1.00))*100) type9_lv, --拆表报警率
		SUM(type10) type10,                --E-7单干簧管故障
		Convert(decimal(18,2),(SUM(type10)/(sum(s)*1.00))*100) type10_lv, --E-7单干簧管故障率
		SUM(type11) type11,                --E-8双干簧管故障
		Convert(decimal(18,2),(SUM(type11)/(sum(s)*1.00))*100) type11_lv, --E-8双干簧管故障率
		SUM(type12) type12,                --E-16周期关阀
		Convert(decimal(18,2),(SUM(type12)/(sum(s)*1.00))*100) type12_lv, --E-16周期关阀率
		SUM(type13) type13,                --E-17过流报警
		Convert(decimal(18,2),(SUM(type13)/(sum(s)*1.00))*100) type13_lv, --E-17过流报警率
		SUM(type14) type14,                --E-21透支关阀
		Convert(decimal(18,2),(SUM(type14)/(sum(s)*1.00))*100) type14_lv, --E-21透支关阀率
		SUM(type15) type15,                --E-23透支过气
		Convert(decimal(18,2),(SUM(type15)/(sum(s)*1.00))*100) type15_lv, --E-23透支过气率
		{groupname} f_insert_date
	FROM(
		SELECT 1 s,
			case when e.f_error_type='抄表异常' then 1 else 0 end type1,
			case when e.f_error_type='信号质量差' then 1 else 0 end type2,
			case when e.f_error_type='电压低' then 1 else 0 end type3,
			case when e.f_error_type='磁干扰' then 1 else 0 end type4,
			case when e.f_error_type='报警关阀' then 1 else 0 end type5,
			case when e.f_error_type='周期关阀' then 1 else 0 end type6,
			case when e.f_error_type='过流保护关阀' then 1 else 0 end type7,
			case when e.f_error_type='关阀走气' then 1 else 0 end type8,
			case when e.f_error_type='拆表报警' then 1 else 0 end type9,
			case when e.f_error_type='E-7单干簧管故障' then 1 else 0 end type10,
			case when e.f_error_type='E-8双干簧管故障' then 1 else 0 end type11,
			case when e.f_error_type='E-16周期关阀' then 1 else 0 end type12,
			case when e.f_error_type='E-17过流报警' then 1 else 0 end type13,
			case when e.f_error_type='E-21透支关阀' then 1 else 0 end type14,
			case when e.f_error_type='E-23透支过气' then 1 else 0 end type15,
			convert(varchar(4),e.f_insert_date,23)+'年' year,
			convert(varchar(7),e.f_insert_date,23) month,
			cast(Datename(week,e.f_insert_date) as int)  week,
			convert(varchar(50),e.f_insert_date,23) day
		FROM t_exception e
		LEFT JOIN t_userfiles f on f.f_user_id=e.f_user_id
		LEFT JOIN t_userinfo u on u.f_userinfo_id=f.f_userinfo_id
		where e.f_insert_date >= '{startDate}' and e.f_insert_date <= '{endDate}'
	    and {condition}
	) t
	GROUP BY {groupname}
) t
GROUP BY f_insert_date,{grouptype},{grouptype}_lv
ORDER BY f_insert_date





