SELECT
	s.id sellid,
	u.f_user_id customer_code,
	s.f_collection Money,
	'JF' + CONVERT (VARCHAR(20), s.id) cid,
	s.f_operator operator,
	s.f_delivery_date charge_date
FROM
	t_sellinggas s
LEFT JOIN t_userfiles u ON u.f_userinfo_id = s.f_userinfo_id
LEFT JOIN t_meterinfo m ON u.f_meternumber = m.f_meternumber
LEFT JOIN t_userinfo i ON u.f_userinfo_id = i.f_userinfo_id
LEFT JOIN (select * from t_stairprice where (getdate()>=f_perform_date and getdate()<=f_end_date)) j ON i.f_price_id = j.f_price_id
LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
WHERE
	(
		s.f_sendsuccess <> '成功'
		OR s.f_sendsuccess IS NULL
	)
AND s.f_charge_type != '自动下账'
AND s.f_charge_type != '用户退费'
AND s.f_charge_state = '有效'
AND DATEDIFF(
	DAY,
	s.f_delivery_date,
	GETDATE ()
) <= 7
AND DATEDIFF(
	DAY,
	s.f_delivery_date,
	GETDATE ()
) >= 0
AND b.f_alias in ({f_meter_brand})
AND u.f_table_state = '正常'
AND j.f_state = '有效'