/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.saifunb;

import com.af.plugins.iot.WebMeterInfo;
import com.aote.sql.SqlServer;
import com.aote.webmeter.module.saifunb.SaiFuInfo;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class SaiFuNBMeterTools {
    private static Logger log = Logger.getLogger(SaiFuNBMeterTools.class);
    @Autowired
    private SqlServer sqlServer;

    public void initialStairPriceInfo() throws Exception {
        WebMeterInfo.setModuleName((String)"SaiFuNB");
        SaiFuInfo.setStairPriceDetailsInfo(this.getPriceDetailsInfo(null));
        SaiFuInfo.setStairPriceInfo(this.getPriceDateInfo(null));
    }

    public synchronized void updateStairPriceInfo(JSONArray jtInfo, JSONArray jtDateInfo) throws Exception {
        WebMeterInfo.setModuleName((String)"SaiFuNB");
        SaiFuInfo.setStairPriceDetailsInfo(this.getPriceDetailsInfo(jtInfo));
        SaiFuInfo.setStairPriceInfo(this.getPriceDateInfo(jtDateInfo));
    }

    public JSONObject getStatus(JSONObject params, String useDateCode) {
        boolean result = true;
        StringBuilder oldDateArray = new StringBuilder(params.getString("RPriceDate"));
        StringBuilder newDateArray = new StringBuilder();
        JSONArray priceInfo = SaiFuInfo.getStairPriceInfo().getJSONArray(useDateCode);
        JSONObject index = this.getJtCodeOrIndex(priceInfo);
        String jt_code = String.valueOf(index.getInt("index"));
        String jt_code2 = String.valueOf(index.getInt("index2"));
        for (int i = 0; i < priceInfo.length(); ++i) {
            JSONObject object = priceInfo.getJSONObject(i);
            if (jt_code.equals(object.getString("jt_code"))) {
                newDateArray.append(object.getString("usedate")).append(" 0 ");
                continue;
            }
            newDateArray.append(object.getString("usedate")).append(" 1 ");
        }
        newDateArray.deleteCharAt(newDateArray.length() - 1);
        if (!oldDateArray.toString().equals(newDateArray.toString())) {
            result = false;
        }
        JSONObject details = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code);
        JSONObject details2 = !jt_code.equals(jt_code2) ? SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code2) : details;
        if (result) {
            if (details2 == details) {
                if (!(params.getString("RLPriceO1").equals(details.getString("jt_new_price_one")) && params.getString("RLPriceO2").equals(details.getString("jt_new_price_two")) && params.getString("RLPriceO3").equals(details.getString("jt_new_price_three")) && params.getString("RLUGasO1").equals(details.getString("jt_new_gas_one")) && params.getString("RLUGasO2").equals(details.getString("jt_new_gas_two")))) {
                    result = false;
                }
            } else if (!(params.getString("RLPriceO1").equals(details.getString("jt_new_price_one")) && params.getString("RLPriceO2").equals(details.getString("jt_new_price_two")) && params.getString("RLPriceO3").equals(details.getString("jt_new_price_three")) && params.getString("RLUGasO1").equals(details.getString("jt_new_gas_one")) && params.getString("RLUGasO2").equals(details.getString("jt_new_gas_two")) && params.getString("RLPriceT1").equals(details2.getString("jt_new_price_one")) && params.getString("RLPriceT2").equals(details2.getString("jt_new_price_two")) && params.getString("RLPriceT3").equals(details2.getString("jt_new_price_three")) && params.getString("RLUGasT1").equals(details2.getString("jt_new_gas_one")) && params.getString("RLUGasT2").equals(details2.getString("jt_new_gas_two")))) {
                result = false;
            }
        }
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", result);
        resultObject.put("dateArray", (Object)newDateArray.toString());
        resultObject.put("typeNum", priceInfo.length());
        resultObject.put("planOne", (Object)details);
        resultObject.put("planTwo", (Object)details2);
        return resultObject;
    }

    public JSONObject getMaxData(String price) {
        JSONObject plan = new JSONObject().put("jt_new_price_one", (Object)price).put("jt_new_price_two", (Object)price).put("jt_new_price_three", (Object)price).put("jt_new_gas_one", (Object)"999999").put("jt_new_gas_two", (Object)"999999");
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", false);
        resultObject.put("dateArray", (Object)"1 1 0");
        resultObject.put("typeNum", (Object)"1");
        resultObject.put("planOne", (Object)plan);
        resultObject.put("planTwo", (Object)plan);
        return resultObject;
    }

    public JSONObject getStairData(String useDateCode) {
        StringBuilder newDateArray = new StringBuilder();
        JSONArray priceInfo = SaiFuInfo.getStairPriceInfo().getJSONArray(useDateCode);
        JSONObject index = this.getJtCodeOrIndex(priceInfo);
        String jt_code = String.valueOf(index.getInt("index"));
        String jt_code2 = String.valueOf(index.getInt("index2"));
        for (int i = 0; i < priceInfo.length(); ++i) {
            JSONObject object = priceInfo.getJSONObject(i);
            if (jt_code.equals(object.getString("jt_code"))) {
                newDateArray.append(object.getString("usedate")).append(" 0 ");
                continue;
            }
            newDateArray.append(object.getString("usedate")).append(" 1 ");
        }
        newDateArray.deleteCharAt(newDateArray.length() - 1);
        JSONObject details = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code);
        JSONObject details2 = !jt_code.equals(jt_code2) ? SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code2) : details;
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", true);
        resultObject.put("dateArray", (Object)newDateArray.toString());
        resultObject.put("typeNum", priceInfo.length());
        resultObject.put("planOne", (Object)details);
        resultObject.put("planTwo", (Object)details2);
        return resultObject;
    }

    private JSONObject getPriceDetailsInfo(JSONArray jtInfo) throws Exception {
        if (jtInfo == null) {
            jtInfo = this.sqlServer.query("webmeterGetBaseData", new JSONObject().put("tableName", (Object)"t_ic_jt_type").put("items", (Object)"*").put("condition", (Object)"1=1"), Integer.valueOf(0));
        }
        JSONObject jtInfoData = new JSONObject();
        for (int i = 0; i < jtInfo.length(); ++i) {
            JSONObject object = jtInfo.getJSONObject(i);
            jtInfoData.put(object.getString("jt_code"), (Object)object);
        }
        return jtInfoData;
    }

    private JSONObject getPriceDateInfo(JSONArray jtDateInfo) throws Exception {
        if (jtDateInfo == null) {
            jtDateInfo = this.sqlServer.query("webmeter_singleTable_OrderBy", new JSONObject().put("tablename", (Object)"t_ic_jt_uesdate").put("items", (Object)"*").put("condition", (Object)"1=1").put("orderitem", (Object)"usedate"), Integer.valueOf(0));
        }
        JSONObject jtDateData = new JSONObject();
        for (int i = 0; i < jtDateInfo.length(); ++i) {
            JSONObject item = jtDateInfo.getJSONObject(i);
            String usedate_code = item.getString("usedate_code");
            String date = item.getString("usedate");
            int charP = date.indexOf("-");
            date = Integer.parseInt(date.substring(0, charP)) + " " + Integer.parseInt(date.substring(charP + 1));
            item.put("usedate", (Object)date);
            if (jtDateData.has(usedate_code)) {
                jtDateData.getJSONArray(usedate_code).put((Object)item);
                continue;
            }
            jtDateData.put(usedate_code, (Object)new JSONArray().put((Object)item));
        }
        return jtDateData;
    }

    public JSONObject getJtCodeOrIndex(JSONArray array) {
        JSONObject result = new JSONObject();
        int jt_code = array.getJSONObject(0).getInt("jt_code");
        result.put("index", jt_code);
        if (array.length() > 1) {
            for (int i = 1; i < array.length(); ++i) {
                int jt_code2 = array.getJSONObject(1).getInt("jt_code");
                if (jt_code2 >= jt_code) continue;
                result.put("index", jt_code2);
                result.put("index2", jt_code);
                break;
            }
        }
        if (!result.has("index2")) {
            result.put("index2", jt_code);
        }
        return result;
    }

    public boolean checkData() {
        return SaiFuInfo.checkData();
    }
}

