select
  {groupname} res,
  sum(_one) _one,
	sum(_five) _five,
	sum(five_seven) five_seven,
	sum(seven_fifteen) seven_fifteen,
	sum(fifteen_thirty) fifteen_thirty,
	sum(thirty_sixty) thirty_sixty,
	sum(sixty_) sixty_
from (
select
  f_user_type,
	f_meternumber,
	f_gasproperties,
	f_gasproperties2,
	f_filiale,
  case when {days} is null then 1 else 0 end _one,
	 case when {days}>0 and {days}<5 then 1 else 0 end _five,
	 case when {days}>=5 and {days}<7 then 1 else 0 end five_seven,
	 case when {days}>=7 and {days}<15 then 1 else 0 end seven_fifteen,
	 case when {days}>=15 and {days}<30 then 1 else 0 end fifteen_thirty,
	 case when {days}>=30 and {days}<60  then 1 else 0 end thirty_sixty,
	 case when {days}>60 then 1 else 0 end sixty_
from(
select
	u.f_meternumber,   --表钢号
 uf.f_userinfo_code, --用户编号
 uf.f_user_name,	--用户姓名
 uf.f_address,		--用户地址
 u.f_gas_date,		--开户日期
 u.f_user_type,		--用户类型
 u.f_gasproperties, --用气类型
 u.f_gasproperties2, --用气属性
case
	when DATEDIFF(day, u.f_gas_date,'{endDate}')<0 then 0
	when DATEDIFF(day, u.f_gas_date,'{startDate}')>=0 then DATEDIFF(day, '{startDate}','{endDate}')-ISNULL(i.normal, 0)+1
	else DATEDIFF(day, u.f_gas_date,'{endDate}')-ISNULL(i.normal, 0)+1
	end all_days,		--合计失联天数
 case when s1.new_instruct_date is null then (
	case when DATEDIFF(day, u.f_gas_date,GETDATE())>1 then DATEDIFF(day, u.f_gas_date,GETDATE())-1 else 0 end)
	else (
	case when DATEDIFF(day, s1.new_instruct_date,GETDATE())>1 then DATEDIFF(day, s1.new_instruct_date,GETDATE())-1 else 0 end) end new_days,		--最新失联天数
  u.f_filialeids,
  u.f_filiale
from t_userfiles u
left join (
select f_user_id,f_userinfo_id,
		SUM(normal) normal,
		min(min_instruct_date) min_insert_date, --首次下发日期
		max(max_instruct_date) max_insert_date --最后下发日期
from (
select
	f_user_id,
	f_userinfo_id,
	convert(varchar(50),f_instruct_date,23) f_instruct_date,
	min(f_instruct_date) min_instruct_date,
	max(f_instruct_date) max_instruct_date,
	case when max(islost)=1 then 1 ELSE 0 end normal
	FROM(
select
	case when f_instruct_state='执行成功' then 1 ELSE 0 end islost,
	f_instruct_date,
	f_user_id,
	f_userinfo_id
from t_instruct
where f_instruct_date>='{startDate}' and f_instruct_date<='{endDate}'
) i
GROUP BY f_user_id,f_userinfo_id,convert(varchar(50),f_instruct_date,23)
) i
GROUP BY f_user_id,f_userinfo_id
) i on u.f_user_id=i.f_user_id
left join t_userinfo uf on u.f_userinfo_id=uf.f_userinfo_id
left join (
	select
		f_user_id,
		f_meternumber,
		max(f_instruct_date) new_instruct_date
	from t_instruct
	where f_instruct_state='执行成功'
	group by f_user_id,f_meternumber
) s1 on s1.f_user_id=u.f_user_id and s1.f_meternumber=u.f_meternumber
where
u.f_gas_date<='{endDate}' and
u.f_table_state='正常' and uf.f_user_state='正常'
) s
where {condition}
) s
group by {groupname}
order by {groupname}


