package com.aote.webmeter.module.saifunb;

import com.af.plugins.iot.WebMeterInfo;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 赛福NB表-秦华对接兼容工具
 * @author Mrriver
 */
@Component
@Transactional(rollbackFor=Exception.class)
public class SaiFuNBMeterTools {
    private static Logger log = Logger.getLogger(SaiFuNBMeterTools.class);
    @Autowired
    private SqlServer sqlServer;

    //初始化阶梯信息
    public void initialStairPriceInfo() throws Exception {
        WebMeterInfo.setModuleName("SaiFuNB");
        SaiFuInfo.setStairPriceDetailsInfo(getPriceDetailsInfo(null));
        SaiFuInfo.setStairPriceInfo(getPriceDateInfo(null));
    }

    //更新阶梯信息
    public synchronized void updateStairPriceInfo(JSONArray jtInfo,JSONArray jtDateInfo) throws Exception {
        WebMeterInfo.setModuleName("SaiFuNB");
        SaiFuInfo.setStairPriceDetailsInfo(getPriceDetailsInfo(jtInfo));
        SaiFuInfo.setStairPriceInfo(getPriceDateInfo(jtDateInfo));
    }

    //获取调价状态
    public JSONObject getStatus(JSONObject params,String useDateCode) {
        boolean result = true;
        StringBuilder oldDateArray = new StringBuilder(params.getString("RPriceDate"));
        StringBuilder newDateArray = new StringBuilder();
        //获取价格数据集合
        JSONArray priceInfo = SaiFuInfo.getStairPriceInfo().getJSONArray(useDateCode);
        //获取索引
        JSONObject index = getJtCodeOrIndex(priceInfo);
        String jt_code = String.valueOf(index.getInt("index"));
        String jt_code2 = String.valueOf(index.getInt("index2"));
        //比较日期
        for(int i = 0 ; i < priceInfo.length() ; i++){
            JSONObject object = priceInfo.getJSONObject(i);
            if(jt_code.equals(object.getString("jt_code"))){
                newDateArray.append(object.getString("usedate")).append(" 0 ");
            } else {
                newDateArray.append(object.getString("usedate")).append(" 1 ");
            }
        }
        //移除最后一位空格
        newDateArray.deleteCharAt(newDateArray.length()-1);
        //如果阶梯日期不一致，则需要调价
        if(!oldDateArray.toString().equals(newDateArray.toString())){
            result = false;
        }
        JSONObject details = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code);
        JSONObject details2;
        if(!jt_code.equals(jt_code2)){
            details2 = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code2);
        } else {
            details2 = details;
        }
        if(result){
            //价格数据比对,价格不一致则需要调价
            if(details2 == details){
                if(!params.getString("RLPriceO1").equals(details.getString("jt_new_price_one")) ||
                        !params.getString("RLPriceO2").equals(details.getString("jt_new_price_two")) ||
                        !params.getString("RLPriceO3").equals(details.getString("jt_new_price_three")) ||
                        !params.getString("RLUGasO1").equals(details.getString("jt_new_gas_one")) ||
                        !params.getString("RLUGasO2").equals(details.getString("jt_new_gas_two"))) {
                    result = false;
                }
            } else {
                if(!params.getString("RLPriceO1").equals(details.getString("jt_new_price_one")) ||
                        !params.getString("RLPriceO2").equals(details.getString("jt_new_price_two")) ||
                        !params.getString("RLPriceO3").equals(details.getString("jt_new_price_three")) ||
                        !params.getString("RLUGasO1").equals(details.getString("jt_new_gas_one")) ||
                        !params.getString("RLUGasO2").equals(details.getString("jt_new_gas_two")) ||
                        !params.getString("RLPriceT1").equals(details2.getString("jt_new_price_one")) ||
                        !params.getString("RLPriceT2").equals(details2.getString("jt_new_price_two")) ||
                        !params.getString("RLPriceT3").equals(details2.getString("jt_new_price_three")) ||
                        !params.getString("RLUGasT1").equals(details2.getString("jt_new_gas_one")) ||
                        !params.getString("RLUGasT2").equals(details2.getString("jt_new_gas_two"))) {
                    result = false;
                }
            }
        }
        JSONObject resultObject = new JSONObject();
        resultObject.put("result",result);
        resultObject.put("dateArray",newDateArray.toString());
        resultObject.put("typeNum",priceInfo.length());
        resultObject.put("planOne",details);
        resultObject.put("planTwo",details2);
        return resultObject;
    }

    //获取固定单价的调价数据结构
    public JSONObject getMaxData(String price){
        JSONObject plan = new JSONObject()
                .put("jt_new_price_one",price)
                .put("jt_new_price_two",price)
                .put("jt_new_price_three",price)
                .put("jt_new_gas_one","999999")
                .put("jt_new_gas_two","999999");
        JSONObject resultObject = new JSONObject();
        resultObject.put("result",false);
        resultObject.put("dateArray","1 1 0");
        resultObject.put("typeNum","1");
        resultObject.put("planOne",plan);
        resultObject.put("planTwo",plan);
        return resultObject;
    }

    //获取阶梯单价的调价数据结构
    public JSONObject getStairData(String useDateCode){
        StringBuilder newDateArray = new StringBuilder();
        //获取价格数据集合
        JSONArray priceInfo = SaiFuInfo.getStairPriceInfo().getJSONArray(useDateCode);
        //获取索引
        JSONObject index = getJtCodeOrIndex(priceInfo);
        String jt_code = String.valueOf(index.getInt("index"));
        String jt_code2 = String.valueOf(index.getInt("index2"));
        //比较日期
        for(int i = 0 ; i < priceInfo.length() ; i++){
            JSONObject object = priceInfo.getJSONObject(i);
            if(jt_code.equals(object.getString("jt_code"))){
                newDateArray.append(object.getString("usedate")).append(" 0 ");
            } else {
                newDateArray.append(object.getString("usedate")).append(" 1 ");
            }
        }
        //移除最后一位空格
        newDateArray.deleteCharAt(newDateArray.length()-1);
        JSONObject details = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code);
        JSONObject details2;
        if(!jt_code.equals(jt_code2)){
            details2 = SaiFuInfo.getStairPriceDetailsInfo().getJSONObject(jt_code2);
        } else {
            details2 = details;
        }
        JSONObject resultObject = new JSONObject();
        resultObject.put("result",true);
        resultObject.put("dateArray",newDateArray.toString());
        resultObject.put("typeNum",priceInfo.length());
        resultObject.put("planOne",details);
        resultObject.put("planTwo",details2);
        return resultObject;
    }

    //获取价格详细信息
    private JSONObject getPriceDetailsInfo(JSONArray jtInfo) throws Exception {
        if(jtInfo == null){
            //查询价格详细信息
            jtInfo = sqlServer.query("webmeterGetBaseData",
                    new JSONObject()
                            .put("tableName","t_ic_jt_type")
                            .put("items","*")
                            .put("condition","1=1"),
                    0);
        }
        JSONObject jtInfoData = new JSONObject();
        for(int i = 0; i < jtInfo.length(); i++){
            JSONObject object = jtInfo.getJSONObject(i);
            jtInfoData.put(object.getString("jt_code"),object);
        }
        return jtInfoData;
    }

    //获取价格周期信息
    private JSONObject getPriceDateInfo(JSONArray jtDateInfo) throws Exception {
        if(jtDateInfo == null){
            //查询价格周期信息
            jtDateInfo = sqlServer.query("webmeter_singleTable_OrderBy",
                    new JSONObject()
                            .put("tablename","t_ic_jt_uesdate")
                            .put("items","*")
                            .put("condition","1=1")
                            .put("orderitem","usedate"),
                    0);
        }
        JSONObject jtDateData = new JSONObject();
        for(int i = 0 ;i < jtDateInfo.length(); i++){
            JSONObject item = jtDateInfo.getJSONObject(i);
            String usedate_code = item.getString("usedate_code");
            String date = item.getString("usedate");
            int charP = date.indexOf("-");
            date = Integer.parseInt(date.substring(0,charP))+" "+Integer.parseInt(date.substring(charP+1));
            item.put("usedate",date);
            if(jtDateData.has(usedate_code)){
                jtDateData.getJSONArray(usedate_code).put(item);
            } else {
                jtDateData.put(usedate_code,new JSONArray().put(item));
            }
        }
        return jtDateData;
    }

    //获取价格方案中的ID及索引
    public JSONObject getJtCodeOrIndex(JSONArray array){
        JSONObject result = new JSONObject();
        int jt_code = array.getJSONObject(0).getInt("jt_code");
        result.put("index",jt_code);
        if(array.length()>1){
            for(int i = 1 ; i<array.length();i++){
                int jt_code2 = array.getJSONObject(1).getInt("jt_code");
                if(jt_code2 < jt_code){
                    result.put("index",jt_code2);
                    result.put("index2",jt_code);
                    break;
                }
            }
        }
        if(!result.has("index2")){
            result.put("index2",jt_code);
        }
        return result;
    }

    public boolean checkData(){
        return SaiFuInfo.checkData();
    }
}
