package com.aote.webmeter.tools.stair;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 收费日期工具插件
 *
 */

public class SaleDateUtil {


    public static void main(String[] args) throws Exception {

        String end = "2018-11-15 15:30:23";

        System.out.println(getYearLastDay(end));
    }


    public static String getYearLastDay (String date) throws Exception{
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        //开始时间
        Date d = sdf.parse(date);

        Calendar temp = Calendar.getInstance();
        temp.setTime(d);

        Calendar calendar = Calendar.getInstance();

        calendar.clear();
        calendar.set(Calendar.YEAR, temp.get(Calendar.YEAR));
        calendar.roll(Calendar.DAY_OF_YEAR, -1);

        return sdf.format(calendar.getTime());

    }


    /**
     * 获取指定时间的年份
     *
     * @param date
     * @return
     * @throws Exception
     */
    public static String getYear(String date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        //开始时间
        Date d = sdf.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return String.valueOf(cal.get(Calendar.YEAR));
    }

    /**
     * 将日期增加或减少相应的月数
     *
     * @param date 被处理的日期
     * @param month 月数差值
     * @return 处理之后的日期
     * @throws Exception
     */
    public static String addMonths(String date, int month) throws Exception {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        //开始时间
        Date d = sdf.parse(date);

        Calendar cal = Calendar.getInstance();

        cal.setTime(d);

        cal.set(Calendar.MONTH, cal.get(Calendar.MONTH) + month);

        return sdf.format(cal.getTime());
    }

    /**
     * 获取两个时间差的天数
     *
     * @param start
     * @param end
     * @return
     * @throws Exception
     */
    public static String getDays(String start, String end) throws Exception{
        //设置转换的日期格式
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        //开始时间
        Date startDate = sdf.parse(start);

        // 处理时分秒
        Calendar start_date = Calendar.getInstance();

        start_date.setTime(startDate);

        start_date.set(Calendar.HOUR_OF_DAY, 0);
        start_date.set(Calendar.MINUTE, 0);
        start_date.set(Calendar.SECOND, 0);
        start_date.set(Calendar.MILLISECOND, 0);

        //结束时间
        Date endDate = sdf.parse(end);

        // 处理时分秒
        Calendar end_date = Calendar.getInstance();

        end_date.setTime(endDate);

        end_date.set(Calendar.HOUR_OF_DAY, 0);
        end_date.set(Calendar.MINUTE, 0);
        end_date.set(Calendar.SECOND, 0);
        end_date.set(Calendar.MILLISECOND, 0);

        //得到相差的天数 betweenDate
        long betweenDate = (start_date.getTime().getTime() - end_date.getTime().getTime())/(60*60*24*1000);

        //打印控制台相差的天数
        return betweenDate + "";
    }

}
