-- 公共SQL：生成调价指令（适用SilverLight1，用于直接使用气价明细调价的情况）
-- 必选参数
-- f_meter_brand：表具品牌别名
-- setPriceSync：调价记录同步状态字段

SELECT
    -- 业务记录ID
    c.id                       id,
    c.f_old_price_id           oldstairid,
    -- 表档案ID
    u.id                       userid,
    -- 表号
    u.f_meternumber,
    -- 卡号
    ISNULL(u.f_cardid, u.f_meternumber)           f_card_id,
    -- 气价ID
    u.f_price_id               stairid,
    -- 价格版本
    ISNULL(u.version, 1)       priceversion,
    -- 阶梯周期（月）
    ISNULL(u.f_stairmonths, 1) f_stairmonths,
    -- 阶梯气价
    u.f_stair1price,
    u.f_stair2price,
    u.f_stair3price,
    -- 阶梯气量
    u.f_stair1amount,
    u.f_stair2amount,
    u.f_stair3amount,
    -- 结算类型（按金额，按气量）
    '按金额' f_collection_type
FROM t_changestairpricedetail c
    LEFT JOIN t_userfiles u ON u.f_userid = c.f_userid
WHERE (c.${setPriceSync} IS NULL or c.${setPriceSync} = '未同步')
  AND u.f_aliasname = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND u.f_price_id > 0
  AND u.f_userstate IN ('正常' ,'停用')
  AND c.id =
      (SELECT MAX(id) FROM t_changestairpricedetail ca where c.f_userid = ca.f_userid)
