package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 设备告警级别
 *
 * @author Mr.river
 */
public enum DeviceAlarmStrategyLevelEnum {

    //公共模块
    dangerous("0","危险报警"),
    significant("1","重要报警"),
    ordinary("2","一般报警");

    private final String value;
    private final String label;

    DeviceAlarmStrategyLevelEnum(String value,String label) {
        this.value = value;
        this.label = label;
    }

    public static DeviceAlarmStrategyLevelEnum toType(String value) {
        return Stream.of(DeviceAlarmStrategyLevelEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }

    public String getLabel(){
        return label;
    }
}
