package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 设备告警策略规则
 *
 * @author Mr.river
 */
public enum DeviceAlarmStrategyCompareTypeEnum {

    //公共模块
    lt("<","小于"),
    lte("<=","小于等于"),
    gt(">","大于"),
    gte(">=","大于等于"),
    equals("=","等于");

    private final String value;
    private final String label;

    DeviceAlarmStrategyCompareTypeEnum(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public static DeviceAlarmStrategyCompareTypeEnum toType(String value) {
        return Stream.of(DeviceAlarmStrategyCompareTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }

    public String getLabel(){
        return label;
    }
}
