package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 物联网表服务 REST请求类型
 * @author Mr.river
 */
public enum RestCodeEnum {
    /**
     * GET请求
     */
    GET("GET"),
    /**
     * POST请求
     */
    POST("POST"),
    /**
     * UPDATE请求
     */
    UPDATE("UPDATE"),
    /**
     * DELETE请求
     */
    DELETE("DELETE");

    private final String value;

    RestCodeEnum(String value) {
        this.value = value;
    }

    public static RestCodeEnum toType(String value) {
        return Stream.of(RestCodeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
