package com.aote.webmeter.enums;

import java.util.stream.Stream;

/**
 * 电信平台订阅类型枚举
 * @author Gear
 */
public enum NotifyTypeEnum {
    //新增设备时订阅
    DEVICE_ADDED("deviceAdded"),
    //设备信息修改时订阅
    DEVICE_INFO_CHANGED("deviceInfoChanged"),
    //设备上报时订阅
    DEVICE_DATA_CHANGED("deviceDataChanged"),
    //设备批量上报时订阅
    DEVICE_DATAS_CHANGED("deviceDatasChanged"),
    //设备删除时订阅
    DEVICE_DELETED("deviceDeleted"),
    //消息确认时订阅
    MESSAGE_CONFIRM("messageConfirm"),
    //服务消息改变时订阅
    SEVICE_INFO_CHANGED("serviceInfoChanged"),
    //命令RSP时订阅
    COMMAND_RSP("commandRsp"),
    //设备事件订阅
    DEVICE_EVENT("deviceEvent"),
    //规则事件订阅
    RULE_EVENT("ruleEvent");

    private final String value;

    NotifyTypeEnum(String value) {
        this.value = value;
    }

    public static NotifyTypeEnum toType(String value) {
        return Stream.of(NotifyTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
