package com.aote.rs;


import com.aote.webmeter.timer.WebMeterTimer;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

/**
 * 物联网表控制器服务
 */
@Path("api")
@Component
public class WebMeterService {
    private static final Logger LOGGER = Logger.getLogger(WebMeterService.class);

    /**
     * 重新加载物联网表模块参数（WebmeterInfo）
     *
     * @return 执行结果
     */
    @GET
    @Path("reloadProp")
    @Produces("text/plain;charset=UTF-8")
    public String reloadWebmeterInfo() {
        LOGGER.debug("重新加载物联网表模块参数");
        //获取物联网表配置文件并加载
        WebMeterInfo.clear();
        WebMeterInfo.load();
        return "命令已处理完成";
    }

    /**
     * 重新加载物联网表Timer指令业务列表（BUSINESS_LIST）
     *
     * @return 执行结果
     */
    @GET
    @Path("reloadTimer")
    @Produces("text/plain;charset=UTF-8")
    public String reloadTimer() {
        LOGGER.debug("重新加载物联网表Timer指令业务列表");
        //获取物联网表Timer指令业务列表并加载
        WebMeterTimer.clear();
        WebMeterTimer.load();
        return "命令已处理完成";
    }
}
