-- 公共SQL：生成初始化调价指令（适用V1，用于直接使用气价明细调价的情况）
-- 必选参数
-- userid：表档案ID

SELECT
    -- 气价方案ID
    s.id                                           stairId,
    -- 表档案ID
    u.f_user_id                                    userId,
    -- 表号
    u.f_meternumber,
    -- 价格名称
    s.f_price_name                                 f_price_name,
    -- 阶梯开始时间
    ISNULL(s.f_stair_start_date, s.f_perform_date) start_date,
    -- 价格生效时间
    s.f_perform_date                               f_perform_date,
    -- 阶梯周期（月）
    ISNULL(s.f_stairmonths, 1)                     f_stairmonths,
    -- 是否采暖气价
    0 f_isheat,
    -- 价格版本
    ISNULL(s.f_version, 1)                         priceversion,
    -- 调价类型
    '设置初始价格'                                   type,
    -- 结算类型（按金额，按气量）
    g.f_collection_type
FROM t_userfiles u
         LEFT JOIN t_stairprice s ON u.f_price_id = s.f_price_id
         LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  AND getdate() <= s.f_end_date
  AND u.f_user_id = '{userid}'
