/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.member.saveInstruct;

import com.aote.sql.SqlServer;
import com.aote.webmeter.common.basic.builder.SaveInstructParamBuilder;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.param.SaveInstructParam;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.InstructTemplate;
import com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder;
import com.aote.webmeter.common.template.result.SaveInstructTemplateResult;
import com.aote.webmeter.enums.InstructInputtorEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Template
public class SaveInstructTemplate
extends InstructTemplate {
    @Autowired
    protected SqlServer sqlServer;
    @Autowired
    protected InstructManage instructManage;
    private final String userId;
    private final InstructTypeEnum type;
    private final String content;
    private final String dataId;
    private final String title;
    private final String alias;
    private final InstructInputtorEnum inputtor;
    private final String moduleName;
    private final JSONObject entity;
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveInstructTemplate.class);

    public SaveInstructTemplate(SaveInstructTemplateBuilder builder) {
        this.userId = builder.getUserId();
        this.type = builder.getType();
        this.content = builder.getContent();
        this.dataId = builder.getDataId();
        this.title = builder.getTitle();
        this.alias = builder.getAlias();
        this.inputtor = builder.getInputtor();
        this.moduleName = builder.getModuleName();
        this.entity = builder.getEntity();
    }

    @Override
    public void beforeExec() {
    }

    @Override
    public SaveInstructTemplateResult exec() throws Exception {
        this.beforeExec();
        String moduleName = this.moduleName;
        if (moduleName != null) {
            WebMeterInfo.setModuleName(moduleName);
        }
        LOGGER.info("----------\u8868\u7f16\u53f7\uff1a{}\u5f00\u59cb\u901a\u8fc7\u6a21\u677f\u4fdd\u5b58\u6307\u4ee4--------", (Object)this.userId);
        SaveInstructParamBuilder builder = SaveInstructParamBuilder.create(this.type, this.userId);
        SaveInstructParam param = builder.setMeterBrandName(this.alias).setTitle(this.title).setInputtor(this.inputtor).setContentData(this.content).setDataId(this.dataId).build();
        String instructId = this.instructManage.save(param);
        LOGGER.info("\u901a\u8fc7\u6a21\u677f\u4fdd\u5b58{}\u6307\u4ee4\u6210\u529f\uff0cID:{}", (Object)this.type.getValue(), (Object)instructId);
        this.afterExec();
        return new SaveInstructTemplateResult(instructId);
    }

    @Override
    public void afterExec() {
    }

    protected SqlServer getSqlServer() {
        return this.sqlServer;
    }

    protected InstructManage getInstructManage() {
        return this.instructManage;
    }

    protected String getUserId() {
        return this.userId;
    }

    protected InstructTypeEnum getType() {
        return this.type;
    }

    protected String getContent() {
        return this.content;
    }

    protected String getDataId() {
        return this.dataId;
    }

    protected String getTitle() {
        return this.title;
    }

    protected String getAlias() {
        return this.alias;
    }

    protected InstructInputtorEnum getInputtor() {
        return this.inputtor;
    }

    protected String getModuleName() {
        return this.moduleName;
    }

    protected JSONObject getEntity() {
        return this.entity;
    }
}

