/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.tools.GetInstructsTools;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetExceptionsTools {
    private static final Logger LOGGER = Logger.getLogger(GetExceptionsTools.class);
    private static final String CONFIG_URL = "webmeter/mainExceptions.json";
    private static final JSONArray EXCEPTION_LIST;

    public JSONArray getExceptionArray(JSONObject params) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < EXCEPTION_LIST.length(); ++i) {
            boolean isException;
            double value;
            Object object;
            JSONObject exception = EXCEPTION_LIST.getJSONObject(i);
            String key = exception.getString("key");
            if (!params.has(key) || (object = params.get(key)) == null) continue;
            try {
                value = params.getDouble(key);
            }
            catch (JSONException e) {
                continue;
            }
            double errorValue = exception.getDouble("value");
            switch (exception.getInt("type")) {
                case 1: {
                    isException = this.isEqual(value, errorValue);
                    break;
                }
                case 2: {
                    isException = !this.isEqual(value, errorValue);
                    break;
                }
                case 3: {
                    isException = value > errorValue;
                    break;
                }
                case 4: {
                    isException = value < errorValue;
                    break;
                }
                default: {
                    isException = false;
                }
            }
            if (!isException) continue;
            JSONObject param = new JSONObject();
            param.put("f_error_level", (Object)exception.getString("level"));
            param.put("f_error_type", (Object)exception.getString("name"));
            String msg = exception.getString("msg");
            if (exception.has("indexArray")) {
                msg = this.format(msg, params, exception.getJSONArray("indexArray"));
            }
            if (exception.has("smsUrl")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("f_userfiles_id", (Object)param.getString("f_userfiles_id"));
                RestTools.post((String)exception.getString("smsUrl"), (JSONObject)jsonObject);
            }
            param.put("f_error_msg", (Object)msg);
            result.put((Object)param);
        }
        return result;
    }

    private String format(String regex, JSONObject params, JSONArray paramsIndex) {
        for (int i = 0; i < paramsIndex.length(); ++i) {
            String key = paramsIndex.getString(i);
            String value = params.optString(key, "-");
            regex = regex.replaceAll("\\{" + i + "}", String.valueOf(value));
        }
        return regex;
    }

    private boolean isEqual(double a, double b) {
        return Double.doubleToLongBits(a) == Double.doubleToLongBits(b);
    }

    static {
        if (GetInstructsTools.class.getClassLoader().getResourceAsStream(CONFIG_URL) == null) {
            throw new RuntimeException("\u7f3a\u5c11\u6284\u8868\u5f02\u5e38\u8bb0\u5f55\u6620\u5c04\u914d\u7f6e\u6587\u4ef6\uff1amainExceptions.json");
        }
        EXCEPTION_LIST = JsonTools.readJsonArrayFile((String)CONFIG_URL);
        LOGGER.debug((Object)"\u52a0\u8f7d\u6284\u8868\u5f02\u5e38\u8bb0\u5f55\u6620\u5c04\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210");
    }
}

