/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.server.tcp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import com.aote.webmeter.tools.tcp.TcpTools;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class TcpServer
extends Thread {
    private static final Logger log = Logger.getLogger(TcpServer.class);
    public final MsgTypeEnum msgSendType;
    private final String name;
    private final int port;
    private final LogicServer service;
    private final String logicName;
    private final MsgTypeEnum msgReceiveType;
    private final boolean isHasChannelData;
    private final String getChannelDataName;
    private Selector selector;

    public TcpServer(String name, String logicName, int port, LogicServer service, MsgTypeEnum msgReceiveType, MsgTypeEnum msgSendType, boolean isHasChannelData, String getChannelDataName) {
        this.name = name;
        this.logicName = logicName;
        this.port = port;
        this.service = service;
        this.msgReceiveType = msgReceiveType;
        this.msgSendType = msgSendType;
        this.isHasChannelData = isHasChannelData;
        this.getChannelDataName = getChannelDataName;
    }

    private void initServer() {
        try {
            this.selector = Selector.open();
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            InetSocketAddress address = new InetSocketAddress(this.port);
            serverChannel.bind(address);
            serverChannel.register(this.selector, 16);
            this.listen();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listen() throws Exception {
        log.debug((Object)("TCP\u670d\u52a1\u7aef\u3010" + this.name + "\u3011\u7684\u3010" + this.port + "\u3011\u7aef\u53e3\u542f\u52a8\u6210\u529f\uff01"));
        while (this.selector.select() > 0) {
            this.selector.select();
            Iterator<SelectionKey> ite = this.selector.selectedKeys().iterator();
            while (ite.hasNext()) {
                SelectionKey key = ite.next();
                ite.remove();
                if (key.isAcceptable()) {
                    ServerSocketChannel server = (ServerSocketChannel)key.channel();
                    SocketChannel sc = server.accept();
                    if (sc == null) continue;
                    sc.configureBlocking(false);
                    sc.register(this.selector, 1);
                    log.debug((Object)(sc.getRemoteAddress() + " \u53d1\u8d77\u8fde\u63a5"));
                    continue;
                }
                if (!key.isReadable()) continue;
                this.read(key);
            }
        }
    }

    private void read(SelectionKey key) throws IOException {
        int recvCount;
        SocketChannel channel = (SocketChannel)key.channel();
        channel.configureBlocking(false);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        String address = channel.getRemoteAddress().toString();
        TcpTools.setChannelMapValue(address, new TcpTools.ChannelData(this.msgSendType, channel));
        TcpTools.setChannelAddress(address);
        try {
            recvCount = channel.read(buffer);
        }
        catch (IOException e) {
            log.debug((Object)(address + "\u65ad\u5f00\u8fde\u63a5..."));
            TcpTools.remove(address);
            log.debug((Object)"\u6e05\u9664\u7f13\u5b58...");
            buffer.clear();
            return;
        }
        if (recvCount > 0) {
            String msg;
            byte[] data = buffer.array();
            log.debug((Object)("\u670d\u52a1\u7aef\u6536\u5230\u539f\u59cb\u4fe1\u606f\uff1a" + Arrays.toString(data)));
            switch (this.msgReceiveType) {
                default: {
                    msg = ConvertTools.bytesToStr((byte[])data);
                    break;
                }
                case HEX: {
                    msg = ConvertTools.byteToHexStr((byte[])data);
                }
            }
            msg = msg.trim().replaceAll("0*$", "").toUpperCase();
            if (this.msgReceiveType == MsgTypeEnum.HEX && (msg.length() & 1) != 0) {
                msg = msg + "0";
            }
            log.debug((Object)("\u670d\u52a1\u7aef\u6536\u5230\u4fe1\u606f\uff1a" + msg));
            JSONObject params = new JSONObject();
            params.put("data", (Object)new JSONObject().put("value", (Object)msg));
            try {
                Object result;
                if (this.isHasChannelData) {
                    JSONObject channelData = TcpTools.getChannelData(address, this.getChannelDataName, params, this.service);
                    params.put("channelData", (Object)channelData);
                }
                if ((result = this.service.run(this.logicName, params)) != null && !result.equals("ok")) {
                    log.debug((Object)("\u670d\u52a1\u7aef\u8fd4\u56de\u4fe1\u606f\uff1a" + result));
                    TcpTools.send(address, String.valueOf(result));
                }
            }
            catch (Exception e) {
                log.error((Object)"\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                log.debug((Object)"\u670d\u52a1\u7aef\u4e3b\u52a8\u65ad\u5f00\u8fde\u63a5...");
                TcpTools.remove(address);
            }
        } else {
            log.debug((Object)"\u5ba2\u6237\u7aef\u8bf7\u6c42\u65ad\u5f00\u8fde\u63a5...");
            TcpTools.remove(address);
        }
        log.debug((Object)"\u6e05\u9664\u7f13\u5b58...");
        buffer.clear();
    }

    @Override
    public void run() {
        this.initServer();
    }
}

