package com.aote.webmeter.tools;

import com.aote.webmeter.entity.MeterRead;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author 张琪
 * @date 2022/10/20 15:12
 */
public class IotEntityTools {
    private static final Logger log = LoggerFactory.getLogger(IotEntityTools.class);

    /**
     * 实体转换类
     */
    private static ObjectMapper objectMapper = new ObjectMapper();

    static {
        // 为默认值则不尽兴序列化
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);

        // 忽略未知字段
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /**
     * 对象转json
     * @param obj
     * @return
     */
    public static JSONObject objectToJson(Object obj){
        String s = null;
        try {
            s = objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return s == null? null: new JSONObject(s);
    }


    public static <T> T jsonToObject(JSONObject json, Class<T> clazz) {
        T t = null;
        try {
            t = objectMapper.readValue(json.toString(), clazz);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return t;
    }
}
