/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.common.basic.param.SaveInstructParam;
import com.aote.webmeter.common.basic.param.SetInstructStateParam;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.InstructInputtorEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class InstructManage {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstructManage.class);
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;

    public String save(SaveInstructParam param) throws Exception {
        LOGGER.info("--------\u4fdd\u5b58{}\u6307\u4ee4--------", (Object)param.getType().getValue());
        SaleVersionEnum saleName = WebMeterInfo.getSaleNameEnum();
        String sqlName = param.getMeterInfoSql();
        if (sqlName == null) {
            switch (saleName) {
                case SILVER_LIGHT: {
                    sqlName = "yinGuangGetMeterInfoBySaveInstruct";
                    break;
                }
                case SILVER_LIGHT2: {
                    sqlName = "yinGuangGetMeterInfo2BySaveInstruct";
                    break;
                }
                default: {
                    sqlName = "getMeterInfoBySaveInstruct";
                }
            }
        }
        String meterBrandName = param.getMeterBrandName() == null ? WebMeterInfo.getString("meterBrandName") : param.getMeterBrandName();
        String condition = param.getCondition() == null ? CompatTools.getBasicCondition(param.getUserId()) : param.getCondition();
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("f_meter_brand", (Object)meterBrandName);
        sqlParams.put("condition", (Object)condition);
        JSONArray userFilesInfo = this.sqlServer.query(sqlName, sqlParams);
        if (userFilesInfo.length() == 0) {
            throw new WebmeterException(BusinessExceptionCodeEnum.USER_FILE_NOT_FIND, condition);
        }
        if (userFilesInfo.length() > 1) {
            throw new WebmeterException(BusinessExceptionCodeEnum.USER_FILE_FIND_MULTIPLE, condition);
        }
        JSONObject userFiles = userFilesInfo.getJSONObject(0);
        InstructEntity instructData = InstructEntity.build(userFiles);
        instructData.setF_instruct_type(param.getType().getValue());
        instructData.setF_alias(meterBrandName);
        instructData.setF_instruct_title(param.getTitle());
        instructData.setF_instruct_state(param.getState().getValue());
        instructData.setF_instruct_content(param.getContentData());
        instructData.setF_inputtor(param.getInputtor().getValue());
        instructData.setF_info(param.getReasonInfo());
        instructData.setF_meteread_id(param.getMetereadId());
        instructData.setF_data_id(param.getDataId());
        instructData.setF_receive_state(param.getState().getReceiveMsg());
        String meterNumber = instructData.getF_meternumber();
        String tableName = CompatTools.getInstructTableName();
        this.cleanRedundancyInstruct(param.getType(), param.getInputtor(), tableName, param.getTitle(), meterNumber);
        JSONObject instruct = JsonTools.convertToJson((String)this.entityServer.partialSaveByEntity(tableName, (Object)instructData));
        LOGGER.info("--------{}\u6307\u4ee4\u4fdd\u5b58\u6210\u529f--------", (Object)param.getType().getValue());
        return String.valueOf(instruct.get("id"));
    }

    public int setInstructState(SetInstructStateParam param) {
        String condition = param.getId() != null ? "id = '" + param.getId() + "'" : (param.getCommandId() != null ? "f_commandId = '" + param.getCommandId() + "'" : param.getCondition());
        String sendDateSql = "";
        String callBackDateSql = "";
        switch (param.getState()) {
            case SUCCESSFUL: 
            case FAILED: {
                String now = DateTools.getNow2();
                sendDateSql = "f_send_date = isnull(f_send_date,'" + now + "'), \n";
                callBackDateSql = "f_callback_date = '" + now + "', \n";
                break;
            }
            case ALREADY_SENT: {
                sendDateSql = "f_send_date = '" + DateTools.getNow2() + "', \n";
            }
        }
        String receiveMsg = param.getReceiveMsg() == null ? param.getState().getReceiveMsg() : param.getReceiveMsg();
        String metaData = param.getMetaData() == null ? "isnull(f_instruct_meta_data,f_instruct_content)" : "'" + param.getMetaData() + "'";
        String syncCommandIdSql = param.getSyncCommandId() == null ? "isnull(f_commandId,id)" : "'" + param.getSyncCommandId() + "'";
        String tableName = CompatTools.getInstructTableName();
        return this.sqlServer.runSQL("UPDATE {} SET \nF_INSTRUCT_STATE = '{}', \nF_RECEIVE_STATE = '{}', \n{}{}F_INSTRUCT_META_DATA = {}, \nF_COMMANDID = {} \nWHERE {} ", new Object[]{tableName, param.getState().getValue(), receiveMsg, sendDateSql, callBackDateSql, metaData, syncCommandIdSql, condition});
    }

    private void cleanRedundancyInstruct(InstructTypeEnum type, InstructInputtorEnum inputtor, String tableName, String title, String meterNumber) {
        if (inputtor != InstructInputtorEnum.SYSTEM_DEFAULT && inputtor != InstructInputtorEnum.CHARGE && inputtor != InstructInputtorEnum.HAND_PLAN) {
            if (type == InstructTypeEnum.ValveControl) {
                if (inputtor == InstructInputtorEnum.SYSTEM_REQUISITE) {
                    this.sqlServer.run("UPDATE {} SET f_instruct_state='\u5ffd\u7565\u5197\u4f59' WHERE F_INSTRUCT_STATE = '\u5f85\u53d1\u9001' AND F_METERNUMBER = '{}' AND F_INSTRUCT_TYPE = '\u9600\u95e8\u63a7\u5236' ", new Object[]{tableName, meterNumber});
                } else {
                    this.sqlServer.run("UPDATE {} SET f_instruct_state='\u5ffd\u7565\u5197\u4f59'WHERE F_INSTRUCT_STATE = '\u5f85\u53d1\u9001' AND F_METERNUMBER = '{}' AND F_INSTRUCT_TYPE = '\u9600\u95e8\u63a7\u5236' AND F_INPUTTOR != '\u7cfb\u7edf\u5fc5\u9700'", new Object[]{tableName, meterNumber});
                }
            } else {
                this.sqlServer.run("UPDATE {} SET f_instruct_state='\u5ffd\u7565\u5197\u4f59' WHERE F_INSTRUCT_STATE = '\u5f85\u53d1\u9001' AND F_METERNUMBER = '{}' AND F_INSTRUCT_TYPE = '{}' AND (F_INSTRUCT_TITLE IS NULL OR F_INSTRUCT_TITLE = '{}') ", new Object[]{tableName, meterNumber, type.getValue(), title});
            }
        }
    }
}

