package com.aote.webmeter.tools.iot.aep;

import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepDeviceCommandClient;
import com.ctg.ag.sdk.biz.AepDeviceCommandLwmProfileClient;
import com.ctg.ag.sdk.biz.aep_device_command.CreateCommandRequest;
import com.ctg.ag.sdk.biz.aep_device_command.CreateCommandResponse;
import com.ctg.ag.sdk.biz.aep_device_command_lwm_profile.CreateCommandLwm2mProfileRequest;
import com.ctg.ag.sdk.biz.aep_device_command_lwm_profile.CreateCommandLwm2mProfileResponse;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;

/**
 * 指令管理
 * @author 物联网小组
 */
public class CommandManager {
    /**
     * 创建指令
     * @param content  指令内容，格式为Json。
     * @param deviceId 设备ID
     * @param ttl  设备指令缓存时长
     * @return 响应结果
     */
    public static JSONObject createCommand(JSONObject content, String deviceId, int ttl) {
        //创建指令下发客户端
        AepDeviceCommandClient client = ClientFactory.getAepDeviceCommandClient();
        try {
            //实例化创建指令请求
            CreateCommandRequest request = new CreateCommandRequest();

            //设置请求参数
            request.setParamMasterKey(WebMeterInfo.getString("MasterKey"));

            //设置请求体
            JSONObject paramsBody = new JSONObject();
            paramsBody.put("content", content);
            paramsBody.put("deviceId", deviceId);
            paramsBody.put("operator", "admin");
            paramsBody.put("ttl", ttl);
            paramsBody.put("level", 1);
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));

            //发起请求，并接收响应
            CreateCommandResponse response = client.CreateCommand(request);

            //将响应的结果转换为JSON数据返回，并设置编码格式
            return new JSONObject(new String(response.getBody(), StandardCharsets.UTF_8));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }

    /**
     * 指令下发(profile类型)
     *
     * @param command  指令内容，格式为JSON
     *           serviceId:命令对应的服务ID,
     * 	         method:命令服务下具体的命令名称
     *           paras:指令参数，格式为json,
     * @param deviceId  设备ID
     * @param ttl  消息超时时长
     * @return 响应结果
     */
    public static JSONObject createCommandLwm2mProfile(JSONObject command, String deviceId, int productId, int ttl) {
        //创建指令下发(profile类型)的客户端对象
        AepDeviceCommandLwmProfileClient client = ClientFactory.getAepDeviceCommandLwmProfileClient();

        try {
            //实例化创建指令（profile类型）的请求对象
            CreateCommandLwm2mProfileRequest request = new CreateCommandLwm2mProfileRequest();
            //设置请求参数
            request.setParamMasterKey(WebMeterInfo.getString("MasterKey"));
            //设置请求体，JSON格式
            JSONObject paramsBody = new JSONObject();
            //指令内容
            paramsBody.put("command",command);
            //设备ID
            paramsBody.put("deviceId",deviceId);
            //操作者
            paramsBody.put("operator","admin");
            //产品ID
            paramsBody.put("productId",productId);
            //消息超时时长
            paramsBody.put("ttl",ttl);
            //指令级别
            paramsBody.put("level", 1);
            //将设置好的请求体放入request请求对象中
            request.setBody(paramsBody.toString().getBytes(StandardCharsets.UTF_8));

            //发送请求，并且接收响应
            CreateCommandLwm2mProfileResponse response=client.CreateCommandLwm2mProfile(request);

            //将响应的数据转换为JSON格式返回，并设置编码格式
            return new JSONObject(new String(response.toString().getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.shutdown();
        }
        return null;
    }
}
