package com.aote.webmeter.common.template.member.runInstruct;


import com.aote.webmeter.common.basic.builder.SetInstructStateParamBuilder;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.pour.PourRunLogic;
import com.aote.webmeter.common.basic.pour.PourRunLogicCall;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.InstructTemplate;
import com.aote.webmeter.common.template.builder.impl.runInstruct.RunInstructTemplateBuilder;
import com.aote.webmeter.common.template.member.saveInstruct.SaveInstructTemplate;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.InstructStateEnum;
import com.aote.webmeter.enums.InstructTypeEnum;
import com.aote.webmeter.enums.MeterTableStateEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import lombok.AccessLevel;
import lombok.Getter;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Getter(AccessLevel.PROTECTED)
@Template
public class RunInstructTemplate extends InstructTemplate {

    @Autowired
    private InstructManage instructManage;

    private final InstructEntity instructEntity;
    private final PourRunLogic pourRunLogic;
    private final PourRunLogicCall pourRunLogicCall;
    private final JSONObject pourCallLogicParams;
    private final String moduleName;

    private static final Logger LOGGER = LoggerFactory.getLogger(SaveInstructTemplate.class);

    public RunInstructTemplate(RunInstructTemplateBuilder builder) {
        this.instructEntity = builder.getInstructEntity();
        this.pourRunLogic = builder.getPourRunLogic();
        this.moduleName = builder.getModuleName();
        this.pourRunLogicCall = builder.getPourRunLogicCall();
        this.pourCallLogicParams = builder.getPourCallLogicParams();
    }

    @Override
    public void beforeExec() {

    }

    /**
     * 执行通用执行指令模板
     * @return 执行指令模板执行结果
     */
    @Override
    public RunInstructTemplateResult exec() {
        String moduleName = this.moduleName;
        if(moduleName != null){
            //设置模块名
            WebMeterInfo.setModuleName(moduleName);
        }
        RunInstructTemplateResult result;
        MeterTableStateEnum tableStateEnum = MeterTableStateEnum.toType(instructEntity.getF_table_state());
        InstructTypeEnum type = InstructTypeEnum.toType(instructEntity.getF_instruct_type());
        //如果表档案状态不是正常，且不是换表/注销指令，直接取消发送该指令
        if(tableStateEnum != null && tableStateEnum != MeterTableStateEnum.NORMAL && type != InstructTypeEnum.ChangeMeter) {
            String receiveMsg = "已自动取消，原因：表档案状态为{object.f_table_state}，预期值：正常";
            SetInstructStateParamBuilder builder = SetInstructStateParamBuilder.create(InstructStateEnum.CANCELED,instructEntity.getId());
            builder.setReceiveMsg(receiveMsg);
            instructManage.setInstructState(builder.build());
            result = new RunInstructTemplateResult(InstructStateEnum.CANCELED);
            result.setReceiveMsg(receiveMsg);
        } else {
            if(instructEntity.getF_meternumber() != null){
                LOGGER.info("----------{}开始执行{}指令--------",instructEntity.getF_meternumber(),type.getValue());
            } else {
                LOGGER.info("----------开始执行{}指令--------",type.getValue());
            }
            //执行注入的逻辑
            result = pourRunLogic.run(instructEntity);
            //执行回调业务逻辑
            if(pourRunLogicCall != null){
                pourRunLogicCall.call(result.getState(),instructEntity,pourCallLogicParams);
            }
            if(result.getIsDisableUpdate()){
                LOGGER.info("禁用更新指令状态");
            } else {
                SetInstructStateParamBuilder builder = SetInstructStateParamBuilder.create(result.getState(),instructEntity.getId());
                builder.setReceiveMsg(result.getReceiveMsg());
                builder.setMetaData(result.getMetaData());
                builder.setSyncCommandId(result.getSyncCommandId());
                instructManage.setInstructState(builder.build());
            }
        }
        LOGGER.info("ID：{}，指令类型：{}，执行完毕：状态：{}，信息：{}",instructEntity.getId(),instructEntity.getF_instruct_type(),result.getState(),result.getReceiveMsg());
        return result;
    }

    @Override
    public void afterExec() {

    }
}
